/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.power.factory.condition.DistanceFromCoordinatesConditionRegistry;
import io.github.apace100.apoli.power.factory.condition.block.LightLevelCondition;
import io.github.apace100.apoli.power.factory.condition.block.MaterialCondition;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockConditions {
    public static void register() {
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, block) -> data.getBoolean("value")));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("offset"), new SerializableData().add("condition", ApoliDataTypes.BLOCK_CONDITION).add("x", SerializableDataTypes.INT, (Object)0).add("y", SerializableDataTypes.INT, (Object)0).add("z", SerializableDataTypes.INT, (Object)0), (data, block) -> ((ConditionFactory.Instance)data.get("condition")).test(new BlockInWorld(block.m_61175_(), block.m_61176_().m_7918_(data.getInt("x"), data.getInt("y"), data.getInt("z")), true))));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("height"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT), (data, block) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(block.m_61176_().m_123342_(), data.getInt("compare_to"))));
        DistanceFromCoordinatesConditionRegistry.registerBlockCondition(BlockConditions::register);
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("block"), new SerializableData().add("block", SerializableDataTypes.BLOCK), (data, block) -> block.m_61168_().m_60713_((Block)data.get("block"))));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.BLOCK_TAG), (data, block) -> {
            if (block == null || block.m_61168_() == null) {
                return false;
            }
            return block.m_61168_().m_204336_((TagKey)data.get("tag"));
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("adjacent"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.INT).add("adjacent_condition", ApoliDataTypes.BLOCK_CONDITION), (data, block) -> {
            ConditionFactory.Instance adjacentCondition = (ConditionFactory.Instance)data.get("adjacent_condition");
            int adjacent = 0;
            for (Direction d : Direction.values()) {
                if (!adjacentCondition.test(new BlockInWorld(block.m_61175_(), block.m_61176_().m_121945_(d), true))) continue;
                ++adjacent;
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(adjacent, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("replacable"), new SerializableData(), (data, block) -> block.m_61168_().m_247087_()));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("attachable"), new SerializableData(), (data, block) -> {
            for (Direction d : Direction.values()) {
                BlockPos adjacent = block.m_61176_().m_121945_(d);
                if (!block.m_61175_().m_8055_(adjacent).m_60783_((BlockGetter)block.m_61175_(), block.m_61176_(), d.m_122424_())) continue;
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("fluid"), new SerializableData().add("fluid_condition", ApoliDataTypes.FLUID_CONDITION), (data, block) -> ((ConditionFactory.Instance)data.get("fluid_condition")).test(block.m_61175_().m_6425_(block.m_61176_()))));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("movement_blocking"), new SerializableData(), (data, block) -> block.m_61168_().m_280555_() && !block.m_61168_().m_60812_((BlockGetter)block.m_61175_(), block.m_61176_()).m_83281_()));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("light_blocking"), new SerializableData(), (data, block) -> block.m_61168_().m_60815_()));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("water_loggable"), new SerializableData(), (data, block) -> block.m_61168_().m_60734_() instanceof LiquidBlockContainer));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("exposed_to_sky"), new SerializableData(), (data, block) -> block.m_61175_().m_45527_(block.m_61176_())));
        BlockConditions.register(LightLevelCondition.getFactory());
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("block_state"), new SerializableData().add("property", SerializableDataTypes.STRING).add("comparison", ApoliDataTypes.COMPARISON, null).add("compare_to", SerializableDataTypes.INT, null).add("value", SerializableDataTypes.BOOLEAN, null).add("enum", SerializableDataTypes.STRING, null), (data, block) -> {
            BlockState state = block.m_61168_();
            Collection properties = state.m_61147_();
            String desiredPropertyName = data.getString("property");
            Property property = null;
            for (Property p : properties) {
                if (!p.m_61708_().equals(desiredPropertyName)) continue;
                property = p;
                break;
            }
            if (property != null) {
                Comparable value = state.m_61143_(property);
                if (data.isPresent("enum") && value instanceof Enum) {
                    return ((Enum)((Object)value)).name().equalsIgnoreCase(data.getString("enum"));
                }
                if (data.isPresent("value") && value instanceof Boolean) {
                    return ((Boolean)value).booleanValue() == data.getBoolean("value");
                }
                if (data.isPresent("comparison") && data.isPresent("compare_to") && value instanceof Integer) {
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Integer)value).intValue(), data.getInt("compare_to"));
                }
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("block_entity"), new SerializableData(), (data, block) -> block.m_61174_() != null));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("nbt"), new SerializableData().add("nbt", SerializableDataTypes.NBT), (data, block) -> {
            CompoundTag nbt = new CompoundTag();
            if (block.m_61174_() != null) {
                nbt = block.m_61174_().m_187480_();
            }
            return NbtUtils.m_129235_((Tag)((CompoundTag)data.get("nbt")), (Tag)nbt, (boolean)true);
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("slipperiness"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            BlockState state = block.m_61168_();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.m_60734_().m_49958_(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("blast_resistance"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            BlockState state = block.m_61168_();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.m_60734_().m_7325_(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<BlockInWorld>(Apoli.identifier("hardness"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, block) -> {
            BlockState state = block.m_61168_();
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(state.m_60734_().m_155943_(), data.getFloat("compare_to"));
        }));
        BlockConditions.register(MaterialCondition.getFactory());
    }

    private static void register(ConditionFactory<BlockInWorld> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.BLOCK_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

