/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.condition;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.BiomeWeatherAccess;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.Comparison;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeConditions {
    public static void register() {
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("constant"), new SerializableData().add("value", SerializableDataTypes.BOOLEAN), (data, biome) -> data.getBoolean("value")));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("and"), new SerializableData().add("conditions", ApoliDataTypes.BIOME_CONDITIONS), (data, biome) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(biome))));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("or"), new SerializableData().add("conditions", ApoliDataTypes.BIOME_CONDITIONS), (data, biome) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(biome))));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("high_humidity"), new SerializableData(), (data, biome) -> ((BiomeWeatherAccess)biome.m_203334_()).getDownfall() > 0.85f));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("temperature"), new SerializableData().add("comparison", ApoliDataTypes.COMPARISON).add("compare_to", SerializableDataTypes.FLOAT), (data, biome) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Biome)biome.m_203334_()).m_47554_(), data.getFloat("compare_to"))));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("category"), new SerializableData().add("category", SerializableDataTypes.STRING), (data, biome) -> {
            ResourceLocation tagId = Apoli.identifier("category/" + data.getString("category"));
            TagKey biomeTag = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagId);
            return biome.m_203656_(biomeTag);
        }));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("precipitation"), new SerializableData().add("precipitation", SerializableDataType.enumValue(Biome.Precipitation.class)), (data, biome) -> ((Biome)biome.m_203334_()).m_264600_(new BlockPos(0, 64, 0)).equals(data.get("precipitation"))));
        BiomeConditions.register(new ConditionFactory<Holder<Biome>>(Apoli.identifier("in_tag"), new SerializableData().add("tag", SerializableDataTypes.BIOME_TAG), (data, biome) -> {
            TagKey biomeTag = (TagKey)data.get("tag");
            return biome.m_203656_(biomeTag);
        }));
    }

    private static void register(ConditionFactory<Holder<Biome>> conditionFactory) {
        Registry.m_122965_(ApoliRegistries.BIOME_CONDITION, (ResourceLocation)conditionFactory.getSerializerId(), conditionFactory);
    }
}

