/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class RaycastAction {
    public static void action(SerializableData.Instance data, Entity entity) {
        BlockHitResult blockHit;
        Vec3 origin = new Vec3(entity.m_20185_(), entity.m_20188_(), entity.m_20189_());
        Vec3 direction = entity.m_20252_(1.0f);
        Vec3 target = origin.m_82549_(direction.m_82490_(((Double)data.get("distance")).doubleValue()));
        data.ifPresent("before_action", action -> action.accept(entity));
        EntityHitResult hitResult = null;
        if (data.getBoolean("entity")) {
            hitResult = RaycastAction.performEntityRaycast(entity, origin, target, (ConditionFactory.Instance)data.get("bientity_condition"));
        }
        if (data.getBoolean("block") && (blockHit = RaycastAction.performBlockRaycast(entity, origin, target, (ClipContext.Block)data.get("shape_type"), (ClipContext.Fluid)data.get("fluid_handling"))).m_6662_() != HitResult.Type.MISS) {
            if (hitResult == null || hitResult.m_6662_() == HitResult.Type.MISS) {
                hitResult = blockHit;
            } else if (hitResult.m_82448_(entity) > blockHit.m_82448_(entity)) {
                hitResult = blockHit;
            }
        }
        if (hitResult != null && hitResult.m_6662_() != HitResult.Type.MISS) {
            if (data.isPresent("command_at_hit")) {
                Vec3 offsetDirection = direction;
                double offset = 0.0;
                Vec3 hitPos = hitResult.m_82450_();
                if (data.isPresent("command_hit_offset")) {
                    offset = data.getDouble("command_hit_offset");
                } else {
                    if (hitResult instanceof BlockHitResult) {
                        BlockHitResult bhr = (BlockHitResult)hitResult;
                        if (bhr.m_82434_() == Direction.DOWN) {
                            offset = entity.m_20206_();
                        } else if (bhr.m_82434_() == Direction.UP) {
                            offset = 0.0;
                        } else {
                            offset = entity.m_20205_() / 2.0f;
                            offsetDirection = new Vec3((double)bhr.m_82434_().m_122429_(), (double)bhr.m_82434_().m_122430_(), (double)bhr.m_82434_().m_122431_()).m_82490_(-1.0);
                        }
                    }
                    offset += 0.05;
                }
                Vec3 at = hitPos.m_82546_(offsetDirection.m_82490_(offset));
                RaycastAction.executeCommandAtHit(entity, at, data.getString("command_at_hit"));
            }
            if (data.isPresent("command_along_ray")) {
                RaycastAction.executeStepCommands(entity, origin, hitResult.m_82450_(), data.getString("command_along_ray"), data.getDouble("command_step"));
            }
            if (data.isPresent("block_action") && hitResult instanceof BlockHitResult) {
                BlockHitResult bhr = (BlockHitResult)hitResult;
                ActionFactory.Instance blockAction = (ActionFactory.Instance)data.get("block_action");
                Triple blockActionContext = Triple.of((Object)entity.m_9236_(), (Object)bhr.m_82425_(), (Object)bhr.m_82434_());
                blockAction.accept(blockActionContext);
            }
            if (data.isPresent("bientity_action") && hitResult instanceof EntityHitResult) {
                EntityHitResult ehr = hitResult;
                ActionFactory.Instance bientityAction = (ActionFactory.Instance)data.get("bientity_action");
                Tuple bientityActionContext = new Tuple((Object)entity, (Object)ehr.m_82443_());
                bientityAction.accept(bientityActionContext);
            }
            data.ifPresent("hit_action", action -> action.accept(entity));
        } else {
            if (data.isPresent("command_along_ray") && !data.getBoolean("command_along_ray_only_on_hit")) {
                RaycastAction.executeStepCommands(entity, origin, target, data.getString("command_along_ray"), data.getDouble("command_step"));
            }
            data.ifPresent("miss_action", action -> action.accept(entity));
        }
    }

    private static void executeStepCommands(Entity entity, Vec3 origin, Vec3 target, String command, double step) {
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server != null) {
            Vec3 direction = target.m_82546_(origin).m_82541_();
            double length = origin.m_82554_(target);
            for (double current = 0.0; current < length; current += step) {
                boolean validOutput = !(entity instanceof ServerPlayer) || ((ServerPlayer)entity).f_8906_ != null;
                CommandSourceStack source = new CommandSourceStack((CommandSource)(Apoli.config.executeCommand.showOutput && validOutput ? entity : CommandSource.f_80164_), origin.m_82549_(direction.m_82490_(current)), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, Apoli.config.executeCommand.permissionLevel, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity);
                server.m_129892_().m_230957_(source, command);
            }
        }
    }

    private static void executeCommandAtHit(Entity entity, Vec3 hitPosition, String command) {
        MinecraftServer server = entity.m_9236_().m_7654_();
        if (server != null) {
            boolean validOutput = !(entity instanceof ServerPlayer) || ((ServerPlayer)entity).f_8906_ != null;
            CommandSourceStack source = new CommandSourceStack((CommandSource)(Apoli.config.executeCommand.showOutput && validOutput ? entity : CommandSource.f_80164_), hitPosition, entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, Apoli.config.executeCommand.permissionLevel, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity);
            server.m_129892_().m_230957_(source, command);
        }
    }

    private static BlockHitResult performBlockRaycast(Entity source, Vec3 origin, Vec3 target, ClipContext.Block shapeType, ClipContext.Fluid fluidHandling) {
        ClipContext context = new ClipContext(origin, target, shapeType, fluidHandling, source);
        return source.m_9236_().m_45547_(context);
    }

    private static EntityHitResult performEntityRaycast(Entity source, Vec3 origin, Vec3 target, ConditionFactory.Instance biEntityCondition) {
        Vec3 ray = target.m_82546_(origin);
        AABB box = source.m_20191_().m_82369_(ray).m_82377_(1.0, 1.0, 1.0);
        EntityHitResult entityHitResult = ProjectileUtil.m_37287_((Entity)source, (Vec3)origin, (Vec3)target, (AABB)box, entityx -> !entityx.m_5833_() && (biEntityCondition == null || biEntityCondition.test(new Tuple((Object)source, entityx))), (double)ray.m_82556_());
        return entityHitResult;
    }

    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory<Entity>(Apoli.identifier("raycast"), new SerializableData().add("distance", SerializableDataTypes.DOUBLE).add("block", SerializableDataTypes.BOOLEAN, (Object)true).add("entity", SerializableDataTypes.BOOLEAN, (Object)true).add("shape_type", SerializableDataType.enumValue(ClipContext.Block.class), (Object)ClipContext.Block.OUTLINE).add("fluid_handling", SerializableDataType.enumValue(ClipContext.Fluid.class), (Object)ClipContext.Fluid.ANY).add("block_action", ApoliDataTypes.BLOCK_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("command_at_hit", SerializableDataTypes.STRING, null).add("command_hit_offset", SerializableDataTypes.DOUBLE, null).add("command_along_ray", SerializableDataTypes.STRING, null).add("command_step", SerializableDataTypes.DOUBLE, (Object)1.0).add("command_along_ray_only_on_hit", SerializableDataTypes.BOOLEAN, (Object)false).add("before_action", ApoliDataTypes.ENTITY_ACTION, null).add("hit_action", ApoliDataTypes.ENTITY_ACTION, null).add("miss_action", ApoliDataTypes.ENTITY_ACTION, null), RaycastAction::action);
    }
}

