/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.InventoryUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModifyInventoryAction {
    public static void action(SerializableData.Instance data, Entity entity) {
        InventoryUtil.InventoryType inventoryType = (InventoryUtil.InventoryType)((Object)data.get("inventory_type"));
        InventoryUtil.ProcessMode processMode = (InventoryUtil.ProcessMode)((Object)data.get("process_mode"));
        int limit = data.getInt("limit");
        switch (inventoryType) {
            case INVENTORY: {
                InventoryUtil.modifyInventory(data, entity, null, processMode.getProcessor(), limit);
                break;
            }
            case POWER: {
                if (!data.isPresent("power") || !(entity instanceof LivingEntity)) {
                    return;
                }
                LivingEntity livingEntity = (LivingEntity)entity;
                PowerType targetPowerType = (PowerType)data.get("power");
                Object targetPower = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)livingEntity)).getPower(targetPowerType);
                if (!(targetPower instanceof InventoryPower)) {
                    return;
                }
                InventoryPower inventoryPower = (InventoryPower)targetPower;
                InventoryUtil.modifyInventory(data, (Entity)livingEntity, inventoryPower, processMode.getProcessor(), limit);
            }
        }
    }

    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory<Entity>(Apoli.identifier("modify_inventory"), new SerializableData().add("inventory_type", ApoliDataTypes.INVENTORY_TYPE, (Object)InventoryUtil.InventoryType.INVENTORY).add("process_mode", ApoliDataTypes.PROCESS_MODE, (Object)InventoryUtil.ProcessMode.STACKS).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null).add("item_action", ApoliDataTypes.ITEM_ACTION).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("slots", ApoliDataTypes.ITEM_SLOTS, null).add("slot", ApoliDataTypes.ITEM_SLOT, null).add("power", ApoliDataTypes.POWER_TYPE, null).add("limit", SerializableDataTypes.INT, (Object)0), ModifyInventoryAction::action);
    }
}

