/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.entity;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class DamageAction {
    public static void action(SerializableData.Instance data, Entity entity) {
        Float damageAmount = (Float)data.get("amount");
        LinkedList<Modifier> modifiers = new LinkedList<Modifier>();
        data.ifPresent("modifier", modifiers::add);
        data.ifPresent("modifiers", modifiers::addAll);
        if (!modifiers.isEmpty() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            damageAmount = Float.valueOf((float)ModifierUtil.applyModifiers((Entity)livingEntity, modifiers, (double)livingEntity.m_21233_()));
        }
        if (damageAmount == null) {
            return;
        }
        try {
            DamageSource damageSource = MiscUtil.createDamageSource(entity.m_269291_(), (DamageSourceDescription)data.get("source"), (ResourceKey<DamageType>)((ResourceKey)data.get("damage_type")));
            entity.m_6469_(damageSource, damageAmount.floatValue());
        }
        catch (Throwable t) {
            Apoli.LOGGER.error("Error trying to deal damage via the `damage` entity action: " + t.getMessage());
        }
    }

    public static ActionFactory<Entity> getFactory() {
        return new ActionFactory<Entity>(Apoli.identifier("damage"), new SerializableData().add("amount", SerializableDataTypes.FLOAT, null).add("source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), DamageAction::action);
    }
}

