/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.block;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class ExplodeAction {
    public static void action(SerializableData.Instance data, Triple<Level, BlockPos, Direction> block) {
        Level world = (Level)block.getLeft();
        if (world.f_46443_) {
            return;
        }
        Predicate<BlockInWorld> indestructibleCondition = (Predicate<BlockInWorld>)data.get("indestructible");
        if (data.isPresent("destructible")) {
            Predicate destructibleCondition = (Predicate)data.get("destructible");
            indestructibleCondition = MiscUtil.combineOr(destructibleCondition.negate(), indestructibleCondition);
        }
        MiscUtil.createExplosion(world, Vec3.m_82512_((Vec3i)((Vec3i)block.getMiddle())), data.getFloat("power"), (Boolean)data.get("create_fire"), (Explosion.BlockInteraction)data.get("destruction_type"), MiscUtil.getExplosionBehavior(world, indestructibleCondition));
    }

    public static ActionFactory<Triple<Level, BlockPos, Direction>> getFactory() {
        return new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("explode"), new SerializableData().add("power", SerializableDataTypes.FLOAT).add("destruction_type", ApoliDataTypes.BACKWARDS_COMPATIBLE_DESTRUCTION_TYPE, (Object)Explosion.BlockInteraction.DESTROY).add("indestructible", ApoliDataTypes.BLOCK_CONDITION, null).add("destructible", ApoliDataTypes.BLOCK_CONDITION, null).add("create_fire", SerializableDataTypes.BOOLEAN, (Object)false), ExplodeAction::action);
    }
}

