/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action.block;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.util.Shape;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import org.apache.commons.lang3.tuple.Triple;

public class AreaOfEffectAction {
    public static void action(SerializableData.Instance data, Triple<Level, BlockPos, Direction> block) {
        Level world = (Level)block.getLeft();
        BlockPos blockPos = (BlockPos)block.getMiddle();
        Direction direction = (Direction)block.getRight();
        int radius = (Integer)data.get("radius");
        Shape shape = (Shape)((Object)data.get("shape"));
        Predicate blockCondition = (Predicate)data.get("block_condition");
        Consumer blockAction = (Consumer)data.get("block_action");
        for (BlockPos collectedBlockPos : Shape.getPositions(blockPos, shape, radius)) {
            if (blockCondition != null && !blockCondition.test(new BlockInWorld((LevelReader)world, collectedBlockPos, true)) || blockAction == null) continue;
            blockAction.accept(Triple.of((Object)world, (Object)collectedBlockPos, (Object)direction));
        }
    }

    public static ActionFactory<Triple<Level, BlockPos, Direction>> getFactory() {
        return new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("area_of_effect"), new SerializableData().add("block_action", ApoliDataTypes.BLOCK_ACTION).add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("radius", SerializableDataTypes.INT, (Object)16).add("shape", SerializableDataType.enumValue(Shape.class), (Object)Shape.CUBE), AreaOfEffectAction::action);
    }
}

