/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.MutableItemStack;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.action.item.HolderAction;
import io.github.apace100.apoli.power.factory.action.meta.AndAction;
import io.github.apace100.apoli.power.factory.action.meta.ChanceAction;
import io.github.apace100.apoli.power.factory.action.meta.ChoiceAction;
import io.github.apace100.apoli.power.factory.action.meta.DelayAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseListAction;
import io.github.apace100.apoli.power.factory.action.meta.NothingAction;
import io.github.apace100.apoli.power.factory.action.meta.SideAction;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.DigDurabilityEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class ItemActions {
    public static void register() {
        ItemActions.register(AndAction.getFactory(ApoliDataTypes.ITEM_ACTIONS));
        ItemActions.register(ChanceAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(IfElseAction.getFactory(ApoliDataTypes.ITEM_ACTION, ApoliDataTypes.ITEM_CONDITION, Tuple::m_14419_));
        ItemActions.register(ChoiceAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(IfElseListAction.getFactory(ApoliDataTypes.ITEM_ACTION, ApoliDataTypes.ITEM_CONDITION, Tuple::m_14419_));
        ItemActions.register(DelayAction.getFactory(ApoliDataTypes.ITEM_ACTION));
        ItemActions.register(NothingAction.getFactory());
        ItemActions.register(SideAction.getFactory(ApoliDataTypes.ITEM_ACTION, worldAndStack -> !((Level)worldAndStack.m_14418_()).f_46443_));
        ItemActions.register(new ActionFactory<Tuple<Level, ItemStack>>(Apoli.identifier("consume"), new SerializableData().add("amount", SerializableDataTypes.INT, (Object)1), (data, worldAndStack) -> ((ItemStack)worldAndStack.m_14419_()).m_41774_(data.getInt("amount"))));
        ItemActions.register(new ActionFactory<Tuple<Level, ItemStack>>(Apoli.identifier("modify"), new SerializableData().add("modifier", SerializableDataTypes.IDENTIFIER), (data, worldAndStack) -> {
            MinecraftServer server = ((Level)worldAndStack.m_14418_()).m_7654_();
            if (server != null) {
                ResourceLocation id = data.getId("modifier");
                LootDataManager lootManager = server.m_278653_();
                LootItemFunction lootFunction = (LootItemFunction)lootManager.m_278789_(LootDataType.f_278496_, id);
                if (lootFunction == null) {
                    Apoli.LOGGER.info("Unknown item modifier used in `modify` action: " + String.valueOf(id));
                    return;
                }
                ServerLevel serverWorld = server.m_129783_();
                ItemStack stack = (ItemStack)worldAndStack.m_14419_();
                LootParams lootContextParameterSet = new LootParams.Builder(serverWorld).m_287286_(LootContextParams.f_81460_, (Object)new Vec3(0.0, 0.0, 0.0)).m_287235_(LootContextParamSets.f_81412_);
                LootContext lootContext = new LootContext.Builder(lootContextParameterSet).m_287259_(null);
                ItemStack newStack = (ItemStack)lootFunction.apply((Object)stack, (Object)lootContext);
                ((MutableItemStack)stack).setFrom(newStack);
            }
        }));
        ItemActions.register(new ActionFactory<Tuple<Level, ItemStack>>(Apoli.identifier("damage"), new SerializableData().add("amount", SerializableDataTypes.INT, (Object)1).add("ignore_unbreaking", SerializableDataTypes.BOOLEAN, (Object)false), (data, worldAndStack) -> {
            if (((ItemStack)worldAndStack.m_14419_()).m_41763_()) {
                int i;
                int amount = data.getInt("amount");
                if (amount > 0 && !data.getBoolean("ignore_unbreaking")) {
                    i = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)((ItemStack)worldAndStack.m_14419_()));
                    int j = 0;
                    for (int k = 0; i > 0 && k < amount; ++k) {
                        if (!DigDurabilityEnchantment.m_220282_((ItemStack)((ItemStack)worldAndStack.m_14419_()), (int)i, (RandomSource)((Level)worldAndStack.m_14418_()).f_46441_)) continue;
                        ++j;
                    }
                    if ((amount -= j) <= 0) {
                        return;
                    }
                }
                i = ((ItemStack)worldAndStack.m_14419_()).m_41773_() + amount;
                ((ItemStack)worldAndStack.m_14419_()).m_41721_(i);
                if (i >= ((ItemStack)worldAndStack.m_14419_()).m_41776_()) {
                    ((ItemStack)worldAndStack.m_14419_()).m_41774_(1);
                    ((ItemStack)worldAndStack.m_14419_()).m_41721_(0);
                }
            }
        }));
        ItemActions.register(new ActionFactory<Tuple<Level, ItemStack>>(Apoli.identifier("merge_nbt"), new SerializableData().add("nbt", SerializableDataTypes.STRING), (data, worldAndStack) -> {
            String nbtString = (String)data.get("nbt");
            try {
                CompoundTag nbt = new TagParser(new StringReader(nbtString)).m_129373_();
                ((ItemStack)worldAndStack.m_14419_()).m_41784_().m_128391_(nbt);
            }
            catch (CommandSyntaxException e) {
                Apoli.LOGGER.error("Failed `merge_nbt` item action due to malformed nbt string: \"" + nbtString + "\"");
            }
        }));
        ItemActions.register(new ActionFactory<Tuple<Level, ItemStack>>(Apoli.identifier("remove_enchantment"), new SerializableData().add("enchantment", SerializableDataTypes.ENCHANTMENT, null).add("enchantments", SerializableDataType.list((SerializableDataType)SerializableDataTypes.ENCHANTMENT), null).add("levels", SerializableDataTypes.INT, null).add("reset_repair_cost", SerializableDataTypes.BOOLEAN, (Object)false), (data, worldAndStack) -> {
            ItemStack stack = (ItemStack)worldAndStack.m_14419_();
            if (!stack.m_41782_()) {
                return;
            }
            LinkedList enchs = new LinkedList();
            data.ifPresent("enchantment", enchs::add);
            data.ifPresent("enchantments", enchs::addAll);
            int levels = -1;
            if (data.isPresent("levels")) {
                levels = data.getInt("levels");
            }
            LinkedHashMap<Enchantment, Integer> enchants = EnchantmentHelper.m_44831_((ItemStack)stack);
            if (enchs.size() > 0) {
                for (Enchantment ench : enchs) {
                    int newLevel;
                    if (!enchants.containsKey(ench)) continue;
                    int n = newLevel = levels == -1 ? 0 : (Integer)enchants.get(ench) - data.getInt("levels");
                    if (newLevel <= 0) {
                        enchants.remove(ench);
                        continue;
                    }
                    enchants.put(ench, newLevel);
                }
            } else {
                LinkedHashMap<Enchantment, Integer> newEnchants = new LinkedHashMap<Enchantment, Integer>();
                for (Enchantment e : enchants.keySet()) {
                    int newLevel = levels == -1 ? 0 : (Integer)enchants.get(e) - data.getInt("levels");
                    if (newLevel <= 0) continue;
                    newEnchants.put(e, newLevel);
                }
                enchants = newEnchants;
            }
            EnchantmentHelper.m_44865_((Map)enchants, (ItemStack)stack);
            if (data.getBoolean("reset_repair_cost") && !stack.m_41793_()) {
                stack.m_41742_(0);
            }
        }));
        ItemActions.register(HolderAction.getFactory());
    }

    private static void register(ActionFactory<Tuple<Level, ItemStack>> actionFactory) {
        Registry.m_122965_(ApoliRegistries.ITEM_ACTION, (ResourceLocation)actionFactory.getSerializerId(), actionFactory);
    }
}

