/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.TogglePower;
import io.github.apace100.apoli.power.VariableIntPower;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.action.entity.AreaOfEffectAction;
import io.github.apace100.apoli.power.factory.action.entity.CraftingTableAction;
import io.github.apace100.apoli.power.factory.action.entity.DamageAction;
import io.github.apace100.apoli.power.factory.action.entity.DropInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.EnderChestAction;
import io.github.apace100.apoli.power.factory.action.entity.ExplodeAction;
import io.github.apace100.apoli.power.factory.action.entity.FireProjectileAction;
import io.github.apace100.apoli.power.factory.action.entity.GrantAdvancementAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyDeathTicksAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyResourceAction;
import io.github.apace100.apoli.power.factory.action.entity.ModifyStatAction;
import io.github.apace100.apoli.power.factory.action.entity.RaycastAction;
import io.github.apace100.apoli.power.factory.action.entity.ReplaceInventoryAction;
import io.github.apace100.apoli.power.factory.action.entity.RevokeAdvancementAction;
import io.github.apace100.apoli.power.factory.action.entity.SelectorAction;
import io.github.apace100.apoli.power.factory.action.entity.SpawnEntityAction;
import io.github.apace100.apoli.power.factory.action.entity.SpawnParticlesAction;
import io.github.apace100.apoli.power.factory.action.entity.SwingHandAction;
import io.github.apace100.apoli.power.factory.action.meta.AndAction;
import io.github.apace100.apoli.power.factory.action.meta.ChanceAction;
import io.github.apace100.apoli.power.factory.action.meta.ChoiceAction;
import io.github.apace100.apoli.power.factory.action.meta.DelayAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseListAction;
import io.github.apace100.apoli.power.factory.action.meta.NothingAction;
import io.github.apace100.apoli.power.factory.action.meta.SideAction;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.ResourceOperation;
import io.github.apace100.apoli.util.Space;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;
import org.joml.Vector3f;

public class EntityActions {
    public static void register() {
        EntityActions.register(AndAction.getFactory(ApoliDataTypes.ENTITY_ACTIONS));
        EntityActions.register(ChanceAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(IfElseAction.getFactory(ApoliDataTypes.ENTITY_ACTION, ApoliDataTypes.ENTITY_CONDITION));
        EntityActions.register(ChoiceAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(IfElseListAction.getFactory(ApoliDataTypes.ENTITY_ACTION, ApoliDataTypes.ENTITY_CONDITION));
        EntityActions.register(DelayAction.getFactory(ApoliDataTypes.ENTITY_ACTION));
        EntityActions.register(NothingAction.getFactory());
        EntityActions.register(SideAction.getFactory(ApoliDataTypes.ENTITY_ACTION, entity -> !entity.m_9236_().f_46443_));
        EntityActions.register(DamageAction.getFactory());
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("heal"), new SerializableData().add("amount", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_5634_(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("play_sound"), new SerializableData().add("sound", SerializableDataTypes.SOUND_EVENT).add("volume", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("pitch", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), (data, entity) -> {
            SoundSource category = entity instanceof Player ? SoundSource.PLAYERS : (entity instanceof Monster ? SoundSource.HOSTILE : SoundSource.NEUTRAL);
            entity.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), (SoundEvent)data.get("sound"), category, data.getFloat("volume"), data.getFloat("pitch"));
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("exhaust"), new SerializableData().add("amount", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof Player) {
                ((Player)entity).m_36324_().m_38703_(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("apply_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                if (!entity.m_9236_().f_46443_) {
                    if (data.isPresent("effect")) {
                        MobEffectInstance effect = (MobEffectInstance)data.get("effect");
                        le.m_7292_(new MobEffectInstance(effect));
                    }
                    if (data.isPresent("effects")) {
                        ((List)data.get("effects")).forEach(e -> le.m_7292_(new MobEffectInstance(e)));
                    }
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("clear_effect"), new SerializableData().add("effect", SerializableDataTypes.STATUS_EFFECT, null), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                if (data.isPresent("effect")) {
                    le.m_21195_((MobEffect)data.get("effect"));
                } else {
                    le.m_21219_();
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("set_on_fire"), new SerializableData().add("duration", SerializableDataTypes.INT), (data, entity) -> entity.m_20254_(data.getInt("duration"))));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("add_velocity"), new SerializableData().add("x", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("y", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("z", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("space", ApoliDataTypes.SPACE, (Object)Space.WORLD).add("client", SerializableDataTypes.BOOLEAN, (Object)true).add("server", SerializableDataTypes.BOOLEAN, (Object)true).add("set", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            if (entity instanceof Player && (entity.m_9236_().f_46443_ ? !data.getBoolean("client") : !data.getBoolean("server"))) {
                return;
            }
            Space space = (Space)((Object)((Object)data.get("space")));
            Vector3f vec = new Vector3f(data.getFloat("x"), data.getFloat("y"), data.getFloat("z"));
            TriConsumer method = (arg_0, arg_1, arg_2) -> ((Entity)entity).m_5997_(arg_0, arg_1, arg_2);
            if (data.getBoolean("set")) {
                method = (arg_0, arg_1, arg_2) -> ((Entity)entity).m_20334_(arg_0, arg_1, arg_2);
            }
            space.toGlobal(vec, (Entity)entity);
            method.accept((Object)Float.valueOf(vec.x), (Object)Float.valueOf(vec.y), (Object)Float.valueOf(vec.z));
            entity.f_19864_ = true;
        }));
        EntityActions.register(SpawnEntityAction.getFactory());
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("gain_air"), new SerializableData().add("value", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                le.m_20301_(Math.min(le.m_20146_() + data.getInt("value"), le.m_6062_()));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("block_action_at"), new SerializableData().add("block_action", ApoliDataTypes.BLOCK_ACTION), (data, entity) -> ((ActionFactory.Instance)data.get("block_action")).accept(Triple.of((Object)entity.m_9236_(), (Object)entity.m_20183_(), (Object)Direction.UP))));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("spawn_effect_cloud"), new SerializableData().add("radius", SerializableDataTypes.FLOAT, (Object)Float.valueOf(3.0f)).add("radius_on_use", SerializableDataTypes.FLOAT, (Object)Float.valueOf(-0.5f)).add("wait_time", SerializableDataTypes.INT, (Object)10).add("effect", SerializableDataTypes.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataTypes.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            if (entity instanceof LivingEntity) {
                areaEffectCloudEntity.m_19718_((LivingEntity)entity);
            }
            areaEffectCloudEntity.m_19712_(data.getFloat("radius"));
            areaEffectCloudEntity.m_19732_(data.getFloat("radius_on_use"));
            areaEffectCloudEntity.m_19740_(data.getInt("wait_time"));
            areaEffectCloudEntity.m_19738_(-areaEffectCloudEntity.m_19743_() / (float)areaEffectCloudEntity.m_19748_());
            LinkedList<MobEffectInstance> effects = new LinkedList<MobEffectInstance>();
            if (data.isPresent("effect")) {
                effects.add((MobEffectInstance)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                effects.addAll((Collection)data.get("effects"));
            }
            areaEffectCloudEntity.m_19714_(PotionUtils.m_43564_(effects));
            effects.forEach(arg_0 -> ((AreaEffectCloud)areaEffectCloudEntity).m_19716_(arg_0));
            entity.m_9236_().m_7967_((Entity)areaEffectCloudEntity);
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("extinguish"), new SerializableData(), (data, entity) -> entity.m_20095_()));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("execute_command"), new SerializableData().add("command", SerializableDataTypes.STRING), (data, entity) -> {
            MinecraftServer server = entity.m_9236_().m_7654_();
            if (server != null) {
                boolean validOutput = !(entity instanceof ServerPlayer) || ((ServerPlayer)entity).f_8906_ != null;
                CommandSourceStack source = new CommandSourceStack((CommandSource)(Apoli.config.executeCommand.showOutput && validOutput ? entity : CommandSource.f_80164_), entity.m_20182_(), entity.m_20155_(), entity.m_9236_() instanceof ServerLevel ? (ServerLevel)entity.m_9236_() : null, Apoli.config.executeCommand.permissionLevel, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), entity);
                server.m_129892_().m_230957_(source, data.getString("command"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("change_resource"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE).add("change", SerializableDataTypes.INT).add("operation", ApoliDataTypes.RESOURCE_OPERATION, (Object)ResourceOperation.ADD), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity);
                PowerType powerType = (PowerType)data.get("resource");
                Object p = component.getPower(powerType);
                ResourceOperation operation = (ResourceOperation)((Object)((Object)data.get("operation")));
                int change = data.getInt("change");
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    if (operation == ResourceOperation.ADD) {
                        int newValue = vip.getValue() + change;
                        vip.setValue(newValue);
                    } else if (operation == ResourceOperation.SET) {
                        vip.setValue(change);
                    }
                    PowerHolderComponent.syncPower(entity, powerType);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    if (operation == ResourceOperation.ADD) {
                        cp.modify(change);
                    } else if (operation == ResourceOperation.SET) {
                        cp.setCooldown(change);
                    }
                    PowerHolderComponent.syncPower(entity, powerType);
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("feed"), new SerializableData().add("food", SerializableDataTypes.INT).add("saturation", SerializableDataTypes.FLOAT), (data, entity) -> {
            if (entity instanceof Player) {
                ((Player)entity).m_36324_().m_38707_(data.getInt("food"), data.getFloat("saturation"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("add_xp"), new SerializableData().add("points", SerializableDataTypes.INT, (Object)0).add("levels", SerializableDataTypes.INT, (Object)0), (data, entity) -> {
            if (entity instanceof Player) {
                int points = data.getInt("points");
                int levels = data.getInt("levels");
                if (points > 0) {
                    ((Player)entity).m_6756_(points);
                }
                ((Player)entity).m_6749_(levels);
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("set_fall_distance"), new SerializableData().add("fall_distance", SerializableDataTypes.FLOAT), (data, entity) -> {
            entity.f_19789_ = data.getFloat("fall_distance");
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("give"), new SerializableData().add("stack", SerializableDataTypes.ITEM_STACK).add("item_action", ApoliDataTypes.ITEM_ACTION, null).add("preferred_slot", SerializableDataTypes.EQUIPMENT_SLOT, null), (data, entity) -> {
            if (!entity.m_9236_().m_5776_()) {
                ItemStack stack = (ItemStack)data.get("stack");
                if (stack.m_41619_()) {
                    return;
                }
                stack = stack.m_41777_();
                if (data.isPresent("item_action")) {
                    ActionFactory.Instance action = (ActionFactory.Instance)data.get("item_action");
                    action.accept(new Tuple((Object)entity.m_9236_(), (Object)stack));
                }
                if (data.isPresent("preferred_slot") && entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    EquipmentSlot slot = (EquipmentSlot)data.get("preferred_slot");
                    ItemStack stackInSlot = living.m_6844_(slot);
                    if (stackInSlot.m_41619_()) {
                        living.m_8061_(slot, stack);
                        return;
                    }
                    if (ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)stack) && stackInSlot.m_41613_() < stackInSlot.m_41741_()) {
                        int fit = Math.min(stackInSlot.m_41741_() - stackInSlot.m_41613_(), stack.m_41613_());
                        stackInSlot.m_41769_(fit);
                        stack.m_41774_(fit);
                        if (stack.m_41619_()) {
                            return;
                        }
                    }
                }
                if (entity instanceof Player) {
                    ((Player)entity).m_150109_().m_150079_(stack);
                } else {
                    entity.m_9236_().m_7967_((Entity)new ItemEntity(entity.m_9236_(), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), stack));
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("equipped_item_action"), new SerializableData().add("equipment_slot", SerializableDataTypes.EQUIPMENT_SLOT).add("action", ApoliDataTypes.ITEM_ACTION), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)entity).m_6844_((EquipmentSlot)data.get("equipment_slot"));
                ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
                action.accept(new Tuple((Object)entity.m_9236_(), (Object)stack));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("trigger_cooldown"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerHolderComponent component;
            Object p;
            if (entity instanceof LivingEntity && (p = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity)).getPower((PowerType)data.get("power"))) instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)p;
                cp.use();
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("toggle"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE), (data, entity) -> {
            PowerHolderComponent component;
            Object p;
            if (entity instanceof LivingEntity && (p = (component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity)).getPower((PowerType)data.get("power"))) instanceof TogglePower) {
                ((TogglePower)p).onUse();
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("emit_game_event"), new SerializableData().add("event", SerializableDataTypes.GAME_EVENT), (data, entity) -> entity.m_146850_((GameEvent)data.get("event"))));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("set_resource"), new SerializableData().add("resource", ApoliDataTypes.POWER_TYPE).add("value", SerializableDataTypes.INT), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get(entity);
                PowerType powerType = (PowerType)data.get("resource");
                Object p = component.getPower(powerType);
                int value = data.getInt("value");
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    vip.setValue(value);
                    PowerHolderComponent.syncPower(entity, powerType);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    cp.setCooldown(value);
                    PowerHolderComponent.syncPower(entity, powerType);
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("grant_power"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE).add("source", SerializableDataTypes.IDENTIFIER), (data, entity) -> PowerHolderComponent.KEY.maybeGet(entity).ifPresent(component -> {
            component.addPower((PowerType)data.get("power"), data.getId("source"));
            component.sync();
        })));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("revoke_power"), new SerializableData().add("power", ApoliDataTypes.POWER_TYPE).add("source", SerializableDataTypes.IDENTIFIER), (data, entity) -> PowerHolderComponent.KEY.maybeGet(entity).ifPresent(component -> {
            component.removePower((PowerType)data.get("power"), data.getId("source"));
            component.sync();
        })));
        EntityActions.register(ExplodeAction.getFactory());
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("dismount"), new SerializableData(), (data, entity) -> entity.m_8127_()));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("passenger_action"), new SerializableData().add("action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("recursive", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            Consumer entityAction = (Consumer)data.get("action");
            Consumer bientityAction = (Consumer)data.get("bientity_action");
            Predicate cond = (Predicate)data.get("bientity_condition");
            if (!entity.m_20160_() || entityAction == null && bientityAction == null) {
                return;
            }
            Iterable passengers = data.getBoolean("recursive") ? entity.m_146897_() : entity.m_20197_();
            for (Entity passenger : passengers) {
                if (cond != null && !cond.test(new Tuple((Object)passenger, entity))) continue;
                if (entityAction != null) {
                    entityAction.accept(passenger);
                }
                if (bientityAction == null) continue;
                bientityAction.accept(new Tuple((Object)passenger, entity));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Apoli.identifier("riding_action"), new SerializableData().add("action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("recursive", SerializableDataTypes.BOOLEAN, (Object)false), (data, entity) -> {
            Consumer entityAction = (Consumer)data.get("action");
            Consumer bientityAction = (Consumer)data.get("bientity_action");
            Predicate cond = (Predicate)data.get("bientity_condition");
            if (!entity.m_20159_() || entityAction == null && bientityAction == null) {
                return;
            }
            if (data.getBoolean("recursive")) {
                for (Entity vehicle = entity.m_20202_(); vehicle != null; vehicle = vehicle.m_20202_()) {
                    if (cond != null && !cond.test(new Tuple(entity, (Object)vehicle))) continue;
                    if (entityAction != null) {
                        entityAction.accept(vehicle);
                    }
                    if (bientityAction == null) continue;
                    bientityAction.accept(new Tuple(entity, (Object)vehicle));
                }
            } else {
                Entity vehicle = entity.m_20202_();
                if (cond == null || cond.test(new Tuple(entity, (Object)vehicle))) {
                    if (entityAction != null) {
                        entityAction.accept(vehicle);
                    }
                    if (bientityAction != null) {
                        bientityAction.accept(new Tuple(entity, (Object)vehicle));
                    }
                }
            }
        }));
        EntityActions.register(AreaOfEffectAction.getFactory());
        EntityActions.register(CraftingTableAction.getFactory());
        EntityActions.register(EnderChestAction.getFactory());
        EntityActions.register(SwingHandAction.getFactory());
        EntityActions.register(RaycastAction.getFactory());
        EntityActions.register(SpawnParticlesAction.getFactory());
        EntityActions.register(ModifyInventoryAction.getFactory());
        EntityActions.register(ReplaceInventoryAction.getFactory());
        EntityActions.register(DropInventoryAction.getFactory());
        EntityActions.register(ModifyDeathTicksAction.getFactory());
        EntityActions.register(ModifyResourceAction.getFactory());
        EntityActions.register(ModifyStatAction.getFactory());
        EntityActions.register(FireProjectileAction.getFactory());
        EntityActions.register(SelectorAction.getFactory());
        EntityActions.register(GrantAdvancementAction.getFactory());
        EntityActions.register(RevokeAdvancementAction.getFactory());
    }

    private static void register(ActionFactory<Entity> actionFactory) {
        Registry.m_122965_(ApoliRegistries.ENTITY_ACTION, (ResourceLocation)actionFactory.getSerializerId(), actionFactory);
    }
}

