/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power.factory.action;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.action.block.AreaOfEffectAction;
import io.github.apace100.apoli.power.factory.action.block.BonemealAction;
import io.github.apace100.apoli.power.factory.action.block.ExplodeAction;
import io.github.apace100.apoli.power.factory.action.block.ModifyBlockStateAction;
import io.github.apace100.apoli.power.factory.action.meta.AndAction;
import io.github.apace100.apoli.power.factory.action.meta.ChanceAction;
import io.github.apace100.apoli.power.factory.action.meta.ChoiceAction;
import io.github.apace100.apoli.power.factory.action.meta.DelayAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseAction;
import io.github.apace100.apoli.power.factory.action.meta.IfElseListAction;
import io.github.apace100.apoli.power.factory.action.meta.NothingAction;
import io.github.apace100.apoli.power.factory.action.meta.SideAction;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Triple;

public class BlockActions {
    public static void register() {
        BlockActions.register(AndAction.getFactory(ApoliDataTypes.BLOCK_ACTIONS));
        BlockActions.register(ChanceAction.getFactory(ApoliDataTypes.BLOCK_ACTION));
        BlockActions.register(IfElseAction.getFactory(ApoliDataTypes.BLOCK_ACTION, ApoliDataTypes.BLOCK_CONDITION, t -> new BlockInWorld((LevelReader)t.getLeft(), (BlockPos)t.getMiddle(), true)));
        BlockActions.register(ChoiceAction.getFactory(ApoliDataTypes.BLOCK_ACTION));
        BlockActions.register(IfElseListAction.getFactory(ApoliDataTypes.BLOCK_ACTION, ApoliDataTypes.BLOCK_CONDITION, t -> new BlockInWorld((LevelReader)t.getLeft(), (BlockPos)t.getMiddle(), true)));
        BlockActions.register(DelayAction.getFactory(ApoliDataTypes.BLOCK_ACTION));
        BlockActions.register(NothingAction.getFactory());
        BlockActions.register(SideAction.getFactory(ApoliDataTypes.BLOCK_ACTION, block -> !((Level)block.getLeft()).f_46443_));
        BlockActions.register(new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("offset"), new SerializableData().add("action", ApoliDataTypes.BLOCK_ACTION).add("x", SerializableDataTypes.INT, (Object)0).add("y", SerializableDataTypes.INT, (Object)0).add("z", SerializableDataTypes.INT, (Object)0), (data, block) -> ((ActionFactory.Instance)data.get("action")).accept(Triple.of((Object)((Level)block.getLeft()), (Object)((BlockPos)block.getMiddle()).m_7918_(data.getInt("x"), data.getInt("y"), data.getInt("z")), (Object)((Direction)block.getRight())))));
        BlockActions.register(new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("set_block"), new SerializableData().add("block", SerializableDataTypes.BLOCK_STATE), (data, block) -> {
            BlockState actualState = (BlockState)data.get("block");
            ((Level)block.getLeft()).m_46597_((BlockPos)block.getMiddle(), actualState);
        }));
        BlockActions.register(new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("add_block"), new SerializableData().add("block", SerializableDataTypes.BLOCK_STATE), (data, block) -> {
            BlockState actualState = (BlockState)data.get("block");
            BlockPos pos = ((BlockPos)block.getMiddle()).m_121945_((Direction)block.getRight());
            ((Level)block.getLeft()).m_46597_(pos, actualState);
        }));
        BlockActions.register(new ActionFactory<Triple<Level, BlockPos, Direction>>(Apoli.identifier("execute_command"), new SerializableData().add("command", SerializableDataTypes.STRING), (data, block) -> {
            MinecraftServer server = ((Level)block.getLeft()).m_7654_();
            if (server != null) {
                String blockName = ((Level)block.getLeft()).m_8055_((BlockPos)block.getMiddle()).m_60734_().m_7705_();
                CommandSourceStack source = new CommandSourceStack((CommandSource)(Apoli.config.executeCommand.showOutput ? server : CommandSource.f_80164_), new Vec3((double)((BlockPos)block.getMiddle()).m_123341_() + 0.5, (double)((BlockPos)block.getMiddle()).m_123342_() + 0.5, (double)((BlockPos)block.getMiddle()).m_123343_() + 0.5), new Vec2(0.0f, 0.0f), (ServerLevel)block.getLeft(), Apoli.config.executeCommand.permissionLevel, blockName, (Component)Component.m_237115_((String)blockName), server, null);
                server.m_129892_().m_230957_(source, data.getString("command"));
            }
        }));
        BlockActions.register(BonemealAction.getFactory());
        BlockActions.register(ModifyBlockStateAction.getFactory());
        BlockActions.register(ExplodeAction.getFactory());
        BlockActions.register(AreaOfEffectAction.getFactory());
    }

    private static void register(ActionFactory<Triple<Level, BlockPos, Direction>> actionFactory) {
        Registry.m_122965_(ApoliRegistries.BLOCK_ACTION, (ResourceLocation)actionFactory.getSerializerId(), actionFactory);
    }
}

