/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;

public class VariableIntPower
extends Power {
    protected final int min;
    protected final int max;
    protected int currentValue;

    public VariableIntPower(PowerType<?> type, LivingEntity entity, int startValue) {
        this(type, entity, startValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public VariableIntPower(PowerType<?> type, LivingEntity entity, int startValue, int min, int max) {
        super(type, entity);
        this.currentValue = startValue;
        this.min = min;
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public int getValue() {
        return this.currentValue;
    }

    public int setValue(int newValue) {
        if (newValue > this.getMax()) {
            newValue = this.getMax();
        }
        if (newValue < this.getMin()) {
            newValue = this.getMin();
        }
        this.currentValue = newValue;
        return this.currentValue;
    }

    public int increment() {
        return this.setValue(this.getValue() + 1);
    }

    public int decrement() {
        return this.setValue(this.getValue() - 1);
    }

    @Override
    public Tag toTag() {
        return IntTag.m_128679_((int)this.currentValue);
    }

    @Override
    public void fromTag(Tag tag) {
        this.currentValue = ((IntTag)tag).m_7047_();
    }
}

