/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class ValueModifyingPower
extends Power {
    private final List<Modifier> modifiers = new LinkedList<Modifier>();

    public ValueModifyingPower(PowerType<?> type, LivingEntity entity) {
        super(type, entity);
    }

    public void addModifier(Modifier modifier) {
        this.modifiers.add(modifier);
    }

    public List<Modifier> getModifiers() {
        return this.modifiers;
    }

    public static PowerFactory createValueModifyingFactory(BiFunction<PowerType, LivingEntity, ValueModifyingPower> powerConstructor, ResourceLocation identifier) {
        return new PowerFactory(identifier, new SerializableData().add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), data -> (type, player) -> {
            ValueModifyingPower power = (ValueModifyingPower)powerConstructor.apply((PowerType)type, (LivingEntity)player);
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            return power;
        }).allowCondition();
    }
}

