/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class TogglePower
extends Power
implements Active {
    private boolean isActive;
    private final boolean shouldRetainState;
    private Active.Key key;

    public TogglePower(PowerType<?> type, LivingEntity entity) {
        this(type, entity, false, true);
    }

    public TogglePower(PowerType<?> type, LivingEntity entity, boolean activeByDefault) {
        this(type, entity, activeByDefault, true);
    }

    public TogglePower(PowerType<?> type, LivingEntity entity, boolean activeByDefault, boolean shouldRetainState) {
        super(type, entity);
        this.shouldRetainState = shouldRetainState;
        this.isActive = activeByDefault;
    }

    @Override
    public boolean shouldTick() {
        return !this.shouldRetainState && this.conditions.size() > 0;
    }

    @Override
    public boolean shouldTickWhenInactive() {
        return true;
    }

    @Override
    public void tick() {
        if (!super.isActive() && this.isActive) {
            this.isActive = false;
            PowerHolderComponent.syncPower((Entity)this.entity, this.type);
        }
    }

    @Override
    public void onUse() {
        this.isActive = !this.isActive;
        PowerHolderComponent.syncPower((Entity)this.entity, this.type);
    }

    @Override
    public boolean isActive() {
        return this.isActive && super.isActive();
    }

    @Override
    public Tag toTag() {
        return ByteTag.m_128273_((boolean)this.isActive);
    }

    @Override
    public void fromTag(Tag tag) {
        this.isActive = ((ByteTag)tag).m_7063_() > 0;
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("toggle"), new SerializableData().add("active_by_default", SerializableDataTypes.BOOLEAN, (Object)true).add("retain_state", SerializableDataTypes.BOOLEAN, (Object)true).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()), data -> (type, player) -> {
            TogglePower power = new TogglePower((PowerType<?>)type, (LivingEntity)player, data.getBoolean("active_by_default"), data.getBoolean("retain_state"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition();
    }
}

