/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class StartingEquipmentPower
extends Power {
    private final List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    private final HashMap<Integer, ItemStack> slottedStacks = new HashMap();
    private boolean recurrent;

    public StartingEquipmentPower(PowerType<?> type, LivingEntity entity) {
        super(type, entity);
    }

    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    public void addStack(ItemStack stack) {
        this.itemStacks.add(stack);
    }

    public void addStack(int slot, ItemStack stack) {
        this.slottedStacks.put(slot, stack);
    }

    @Override
    public void onGained() {
        this.giveStacks();
    }

    @Override
    public void onRespawn() {
        if (this.recurrent) {
            this.giveStacks();
        }
    }

    private void giveStacks() {
        this.slottedStacks.forEach((slot, stack) -> {
            if (this.entity instanceof Player) {
                Player player = (Player)this.entity;
                Inventory inventory = player.m_150109_();
                if (inventory.m_8020_(slot.intValue()).m_41619_()) {
                    inventory.m_6836_(slot.intValue(), stack);
                } else {
                    player.m_36356_(stack);
                }
            } else {
                this.entity.m_19983_(stack);
            }
        });
        this.itemStacks.forEach(is -> {
            ItemStack copy = is.m_41777_();
            if (this.entity instanceof Player) {
                Player player = (Player)this.entity;
                player.m_36356_(copy);
            } else {
                this.entity.m_19983_(copy);
            }
        });
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("starting_equipment"), new SerializableData().add("stack", ApoliDataTypes.POSITIONED_ITEM_STACK, null).add("stacks", ApoliDataTypes.POSITIONED_ITEM_STACKS, null).add("recurrent", SerializableDataTypes.BOOLEAN, (Object)false), data -> (type, player) -> {
            StartingEquipmentPower power = new StartingEquipmentPower((PowerType<?>)type, (LivingEntity)player);
            if (data.isPresent("stack")) {
                Tuple stack = (Tuple)data.get("stack");
                int slot = (Integer)stack.m_14418_();
                if (slot > Integer.MIN_VALUE) {
                    power.addStack((Integer)stack.m_14418_(), (ItemStack)stack.m_14419_());
                } else {
                    power.addStack((ItemStack)stack.m_14419_());
                }
            }
            if (data.isPresent("stacks")) {
                ((List)data.get("stacks")).forEach(integerItemStackPair -> {
                    int slot = (Integer)integerItemStackPair.m_14418_();
                    if (slot > Integer.MIN_VALUE) {
                        power.addStack((Integer)integerItemStackPair.m_14418_(), (ItemStack)integerItemStackPair.m_14419_());
                    } else {
                        power.addStack((ItemStack)integerItemStackPair.m_14419_());
                    }
                });
            }
            power.setRecurrent(data.getBoolean("recurrent"));
            return power;
        });
    }
}

