/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SelfActionOnKillPower
extends CooldownPower {
    private final Predicate<Tuple<DamageSource, Float>> damageCondition;
    private final Predicate<Entity> targetCondition;
    private final Consumer<Entity> entityAction;

    public SelfActionOnKillPower(PowerType<?> type, LivingEntity entity, int cooldownDuration, HudRender hudRender, Predicate<Tuple<DamageSource, Float>> damageCondition, Consumer<Entity> entityAction, Predicate<Entity> targetCondition) {
        super(type, entity, cooldownDuration, hudRender);
        this.damageCondition = damageCondition;
        this.entityAction = entityAction;
        this.targetCondition = targetCondition;
    }

    public void onKill(Entity target, DamageSource damageSource, float damageAmount) {
        if ((this.targetCondition == null || this.targetCondition.test(target)) && (this.damageCondition == null || this.damageCondition.test((Tuple<DamageSource, Float>)new Tuple((Object)damageSource, (Object)Float.valueOf(damageAmount)))) && this.canUse()) {
            this.entityAction.accept((Entity)this.entity);
            this.use();
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("self_action_on_kill"), new SerializableData().add("entity_action", ApoliDataTypes.ENTITY_ACTION).add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> new SelfActionOnKillPower((PowerType<?>)type, (LivingEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (ConditionFactory.Instance)data.get("damage_condition"), (ActionFactory.Instance)data.get("entity_action"), (ConditionFactory.Instance)data.get("target_condition"))).allowCondition();
    }
}

