/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.IdentifiedLootTable;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.ClassUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ReplaceLootTablePower
extends Power {
    public static final ResourceLocation REPLACED_TABLE_UTIL_ID = new ResourceLocation("apoli", "replaced_loot_table");
    public static ResourceLocation LAST_REPLACED_TABLE_ID;
    private static Stack<LootTable> REPLACEMENT_STACK;
    private static Stack<LootTable> BACKTRACK_STACK;
    private final Map<String, ResourceLocation> replacements;
    private final int priority;
    private final Predicate<ItemStack> itemCondition;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;
    private final Predicate<BlockInWorld> blockCondition;
    private static final SerializableDataType<Map<String, ResourceLocation>> REPLACEMENTS_DATA_TYPE;

    public ReplaceLootTablePower(PowerType<?> type, LivingEntity entity, Map<String, ResourceLocation> replacements, int priority, Predicate<ItemStack> itemCondition, Predicate<Tuple<Entity, Entity>> biEntityCondition, Predicate<BlockInWorld> blockCondition) {
        super(type, entity);
        this.replacements = replacements;
        this.priority = priority;
        this.itemCondition = itemCondition;
        this.biEntityCondition = biEntityCondition;
        this.blockCondition = blockCondition;
    }

    public boolean hasReplacement(ResourceLocation id) {
        String idString = id.toString();
        if (this.replacements.containsKey(idString)) {
            return true;
        }
        return this.replacements.keySet().stream().anyMatch(idString::matches);
    }

    public boolean doesApply(LootContext lootContext) {
        if (this.biEntityCondition != null && !this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)this.entity, (Object)((Entity)lootContext.m_78953_(LootContextParams.f_81455_))))) {
            return false;
        }
        if (this.itemCondition != null && lootContext.m_78936_(LootContextParams.f_81463_) && !this.itemCondition.test((ItemStack)lootContext.m_78953_(LootContextParams.f_81463_))) {
            return false;
        }
        if (this.blockCondition != null && lootContext.m_78936_(LootContextParams.f_81460_)) {
            BlockPos blockPos = BlockPos.m_274446_((Position)((Position)lootContext.m_78953_(LootContextParams.f_81460_)));
            BlockInWorld cbp = new BlockInWorld((LevelReader)lootContext.m_78952_(), blockPos, true);
            if (!this.blockCondition.test(cbp)) {
                return false;
            }
        }
        return true;
    }

    public ResourceLocation getReplacement(ResourceLocation id) {
        String idString = id.toString();
        if (this.replacements.containsKey(idString)) {
            return this.replacements.get(idString);
        }
        Set<String> keys = this.replacements.keySet();
        for (String s : keys) {
            if (!idString.matches(s)) continue;
            return this.replacements.get(s);
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public static void clearStack() {
        REPLACEMENT_STACK.clear();
        BACKTRACK_STACK.clear();
    }

    public static void addToStack(LootTable lootTable) {
        REPLACEMENT_STACK.add(lootTable);
    }

    public static LootTable pop() {
        if (REPLACEMENT_STACK.isEmpty()) {
            return LootTable.f_79105_;
        }
        LootTable table = REPLACEMENT_STACK.pop();
        BACKTRACK_STACK.push(table);
        return table;
    }

    public static LootTable restore() {
        if (BACKTRACK_STACK.isEmpty()) {
            return LootTable.f_79105_;
        }
        LootTable table = BACKTRACK_STACK.pop();
        REPLACEMENT_STACK.push(table);
        return table;
    }

    public static LootTable peek() {
        if (REPLACEMENT_STACK.isEmpty()) {
            return LootTable.f_79105_;
        }
        return REPLACEMENT_STACK.peek();
    }

    private static void printStacks() {
        LootTable t;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        int count = 0;
        while (!REPLACEMENT_STACK.isEmpty()) {
            t = ReplaceLootTablePower.pop();
            stringBuilder.append((Object)(t == null ? "null" : ((IdentifiedLootTable)t).getId()));
            if (!REPLACEMENT_STACK.isEmpty()) {
                stringBuilder.append(", ");
            }
            ++count;
        }
        stringBuilder.append("], [");
        while (count > 0) {
            ReplaceLootTablePower.restore();
            --count;
        }
        while (BACKTRACK_STACK.size() > 0) {
            t = ReplaceLootTablePower.restore();
            stringBuilder.append((Object)(t == null ? "null" : ((IdentifiedLootTable)t).getId()));
            if (!BACKTRACK_STACK.isEmpty()) {
                stringBuilder.append(", ");
            }
            ++count;
        }
        while (count > 0) {
            ReplaceLootTablePower.pop();
            --count;
        }
        stringBuilder.append("]");
        Apoli.LOGGER.info(stringBuilder.toString());
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(new ResourceLocation("apoli", "replace_loot_table"), new SerializableData().add("replace", REPLACEMENTS_DATA_TYPE).add("priority", SerializableDataTypes.INT, (Object)0).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("item_condition", ApoliDataTypes.ITEM_CONDITION, null).add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null), data -> (type, player) -> new ReplaceLootTablePower((PowerType<?>)type, (LivingEntity)player, (Map)data.get("replace"), (Integer)data.get("priority"), (Predicate)data.get("item_condition"), (Predicate)data.get("bientity_condition"), (Predicate)data.get("block_condition"))).allowCondition();
    }

    static {
        REPLACEMENT_STACK = new Stack();
        BACKTRACK_STACK = new Stack();
        REPLACEMENTS_DATA_TYPE = new SerializableDataType(ClassUtil.castClass(Map.class), (packetByteBuf, stringIdentifierMap) -> {
            packetByteBuf.writeInt(stringIdentifierMap.size());
            stringIdentifierMap.forEach((s, identifier) -> {
                packetByteBuf.m_130070_(s);
                packetByteBuf.m_130085_(identifier);
            });
        }, packetByteBuf -> {
            int count = packetByteBuf.readInt();
            LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
            for (int i = 0; i < count; ++i) {
                String s = packetByteBuf.m_130277_();
                ResourceLocation id = packetByteBuf.m_130281_();
                map.put(s, id);
            }
            return map;
        }, jsonElement -> {
            if (jsonElement.isJsonObject()) {
                JsonObject jo = jsonElement.getAsJsonObject();
                LinkedHashMap<String, ResourceLocation> map = new LinkedHashMap<String, ResourceLocation>();
                for (String s : jo.keySet()) {
                    JsonPrimitive jp;
                    JsonElement ele = jo.get(s);
                    if (!ele.isJsonPrimitive() || !(jp = ele.getAsJsonPrimitive()).isString()) continue;
                    ResourceLocation id = new ResourceLocation(jp.getAsString());
                    map.put(s, id);
                }
                return map;
            }
            throw new JsonParseException("Expected a JSON object");
        });
    }
}

