/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class PreventItemUsePower
extends Power {
    private final Predicate<ItemStack> predicate;

    public PreventItemUsePower(PowerType<?> type, LivingEntity entity, Predicate<ItemStack> predicate) {
        super(type, entity);
        this.predicate = predicate;
    }

    public boolean doesPrevent(ItemStack stack) {
        return this.predicate.test(stack);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("prevent_item_use"), new SerializableData().add("item_condition", ApoliDataTypes.ITEM_CONDITION, null), data -> (type, player) -> new PreventItemUsePower((PowerType<?>)type, (LivingEntity)player, data.isPresent("item_condition") ? (ConditionFactory.Instance)data.get("item_condition") : item -> true)).allowCondition();
    }
}

