/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.gameevent.GameEvent;

public class PreventGameEventPower
extends Power {
    private final TagKey<GameEvent> tag;
    private final List<GameEvent> list;
    private final Consumer<Entity> entityAction;

    public PreventGameEventPower(PowerType<?> type, LivingEntity entity, TagKey<GameEvent> tag, List<GameEvent> list, Consumer<Entity> entityAction) {
        super(type, entity);
        this.tag = tag;
        this.list = list;
        this.entityAction = entityAction;
    }

    public void executeAction(Entity entity) {
        if (this.entityAction != null) {
            this.entityAction.accept(entity);
        }
    }

    public boolean doesPrevent(GameEvent event) {
        if (this.tag != null && event.m_204528_(this.tag)) {
            return true;
        }
        return this.list != null && this.list.contains(event);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("prevent_game_event"), new SerializableData().add("event", SerializableDataTypes.GAME_EVENT, null).add("events", SerializableDataTypes.GAME_EVENTS, null).add("tag", SerializableDataTypes.GAME_EVENT_TAG, null).add("entity_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> {
            LinkedList<GameEvent> eventList;
            LinkedList<GameEvent> linkedList = eventList = data.isPresent("events") ? (LinkedList<GameEvent>)data.get("events") : null;
            if (data.isPresent("event")) {
                if (eventList == null) {
                    eventList = new LinkedList<GameEvent>();
                }
                eventList.add((GameEvent)data.get("event"));
            }
            return new PreventGameEventPower((PowerType<?>)type, (LivingEntity)player, (TagKey<GameEvent>)((TagKey)data.get("tag")), (List<GameEvent>)eventList, (Consumer)data.get("entity_action"));
        }).allowCondition();
    }
}

