/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.factory.PowerFactory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class PowerType<T extends Power> {
    private ResourceLocation identifier;
    private PowerFactory.Instance factory;
    private boolean isHidden = false;
    private String nameTranslationKey;
    private String descriptionTranslationKey;

    public PowerType(ResourceLocation id, PowerFactory.Instance factory) {
        this.identifier = id;
        this.factory = factory;
    }

    public ResourceLocation getIdentifier() {
        return this.identifier;
    }

    public PowerFactory.Instance getFactory() {
        return this.factory;
    }

    public PowerType setHidden() {
        this.isHidden = true;
        return this;
    }

    public void setTranslationKeys(String name, String description) {
        this.nameTranslationKey = name;
        this.descriptionTranslationKey = description;
    }

    public T create(LivingEntity entity) {
        return (T)this.getFactory().apply(this, entity);
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isActive(Entity entity) {
        PowerHolderComponent component;
        if (entity instanceof LivingEntity && this.identifier != null && (component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity)).hasPower(this)) {
            return ((Power)component.getPower(this)).isActive();
        }
        return false;
    }

    public T get(Entity entity) {
        if (entity instanceof LivingEntity) {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)entity);
            return component.getPower(this);
        }
        return null;
    }

    public String getOrCreateNameTranslationKey() {
        if (this.nameTranslationKey == null || this.nameTranslationKey.isEmpty()) {
            this.nameTranslationKey = "power." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".name";
        }
        return this.nameTranslationKey;
    }

    public MutableComponent getName() {
        return Component.m_237115_((String)this.getOrCreateNameTranslationKey());
    }

    public String getOrCreateDescriptionTranslationKey() {
        if (this.descriptionTranslationKey == null || this.descriptionTranslationKey.isEmpty()) {
            this.descriptionTranslationKey = "power." + this.identifier.m_135827_() + "." + this.identifier.m_135815_() + ".description";
        }
        return this.descriptionTranslationKey;
    }

    public MutableComponent getDescription() {
        return Component.m_237115_((String)this.getOrCreateDescriptionTranslationKey());
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PowerType)) {
            return false;
        }
        ResourceLocation id = ((PowerType)obj).getIdentifier();
        return this.identifier.equals((Object)id);
    }
}

