/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class PhasingPower
extends Power {
    private final Predicate<BlockInWorld> blocks;
    private final boolean isBlacklist;
    private final Predicate<Entity> phaseDownCondition;
    private final RenderType renderType;
    private final float viewDistance;

    public PhasingPower(PowerType<?> type, LivingEntity entity, Predicate<BlockInWorld> blocks, boolean isBlacklist, RenderType renderType, float viewDistance, Predicate<Entity> phaseDownCondition) {
        super(type, entity);
        this.blocks = blocks;
        this.isBlacklist = isBlacklist;
        this.renderType = renderType;
        this.viewDistance = viewDistance;
        this.phaseDownCondition = phaseDownCondition;
    }

    public boolean doesApply(BlockPos pos) {
        return this.isBlacklist != this.blocks.test(new BlockInWorld((LevelReader)this.entity.m_9236_(), pos, true));
    }

    public boolean shouldPhaseDown(Entity entity) {
        return this.phaseDownCondition == null ? entity.m_6144_() : this.phaseDownCondition.test(entity);
    }

    public RenderType getRenderType() {
        return this.renderType;
    }

    public float getViewDistance() {
        return this.viewDistance;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("phasing"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("blacklist", SerializableDataTypes.BOOLEAN, (Object)false).add("render_type", SerializableDataType.enumValue(RenderType.class), (Object)RenderType.BLINDNESS).add("view_distance", SerializableDataTypes.FLOAT, (Object)Float.valueOf(10.0f)).add("phase_down_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> new PhasingPower((PowerType<?>)type, (LivingEntity)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true, data.getBoolean("blacklist"), (RenderType)((Object)((Object)((Object)data.get("render_type")))), data.getFloat("view_distance"), (Predicate)data.get("phase_down_condition"))).allowCondition();
    }

    public static enum RenderType {
        BLINDNESS,
        REMOVE_BLOCKS,
        NONE;

    }
}

