/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class ModifySlipperinessPower
extends ValueModifyingPower {
    private final Predicate<BlockInWorld> predicate;

    public ModifySlipperinessPower(PowerType<?> type, LivingEntity entity, Predicate<BlockInWorld> predicate) {
        super(type, entity);
        this.predicate = predicate;
    }

    public boolean doesApply(LevelReader world, BlockPos pos) {
        if (this.predicate == null) {
            return true;
        }
        BlockInWorld cbp = new BlockInWorld(world, pos, true);
        return this.predicate.test(cbp);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_slipperiness"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null), data -> (type, player) -> {
            ModifySlipperinessPower power = new ModifySlipperinessPower((PowerType<?>)type, (LivingEntity)player, (Predicate)data.get("block_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            return power;
        }).allowCondition();
    }
}

