/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModifyProjectileDamagePower
extends ValueModifyingPower {
    private final Predicate<Tuple<DamageSource, Float>> condition;
    private final Predicate<Entity> targetCondition;
    private Consumer<Entity> targetAction;
    private Consumer<Entity> selfAction;

    public ModifyProjectileDamagePower(PowerType<?> type, LivingEntity entity, Predicate<Tuple<DamageSource, Float>> condition, Predicate<Entity> targetCondition) {
        super(type, entity);
        this.condition = condition;
        this.targetCondition = targetCondition;
    }

    public boolean doesApply(DamageSource source, float damageAmount, LivingEntity target) {
        return this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount))) && (target == null || this.targetCondition == null || this.targetCondition.test((Entity)target));
    }

    public void setTargetAction(Consumer<Entity> targetAction) {
        this.targetAction = targetAction;
    }

    public void setSelfAction(Consumer<Entity> selfAction) {
        this.selfAction = selfAction;
    }

    public void executeActions(Entity target) {
        if (this.selfAction != null) {
            this.selfAction.accept((Entity)this.entity);
        }
        if (this.targetAction != null) {
            this.targetAction.accept(target);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_projectile_damage"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("target_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("target_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyProjectileDamagePower power = new ModifyProjectileDamagePower((PowerType<?>)type, (LivingEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition();
    }
}

