/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import com.mojang.datafixers.util.Pair;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.function.TriFunction;

public class ModifyPlayerSpawnPower
extends Power {
    public final ResourceKey<Level> dimension;
    public final float dimensionDistanceMultiplier;
    public final ResourceLocation biomeId;
    public final SpawnStrategy spawnStrategy;
    public final ResourceKey<Structure> structure;
    public final SoundEvent spawnSound;

    public ModifyPlayerSpawnPower(PowerType<?> type, LivingEntity entity, ResourceKey<Level> dimension, float dimensionDistanceMultiplier, ResourceLocation biomeId, SpawnStrategy spawnStrategy, ResourceKey<Structure> structure, SoundEvent spawnSound) {
        super(type, entity);
        this.dimension = dimension;
        this.dimensionDistanceMultiplier = dimensionDistanceMultiplier;
        this.biomeId = biomeId;
        this.spawnStrategy = spawnStrategy;
        this.structure = structure;
        this.spawnSound = spawnSound;
    }

    @Override
    public void onRemoved() {
        LivingEntity livingEntity;
        if (this.entity.m_9236_().f_46443_ || !((livingEntity = this.entity) instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)livingEntity;
        ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
        if (serverPlayerEntity.m_9232_() || serverPlayerEntity.m_8961_() == null || !serverPlayerEntity.m_8964_()) {
            return;
        }
        serverPlayerEntity.m_9158_(Level.f_46428_, null, 0.0f, false, false);
    }

    public void teleportToModifiedSpawn() {
        LivingEntity livingEntity;
        if (this.entity.m_9236_().f_46443_ || !((livingEntity = this.entity) instanceof Player)) {
            return;
        }
        Player playerEntity = (Player)livingEntity;
        ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
        Tuple<ServerLevel, BlockPos> newSpawn = this.getSpawn(false);
        if (newSpawn == null) {
            return;
        }
        ServerLevel newSpawnDimension = (ServerLevel)newSpawn.m_14418_();
        BlockPos newSpawnPos = (BlockPos)newSpawn.m_14419_();
        Vec3 tpPos = DismountHelper.m_38441_((EntityType)playerEntity.m_6095_(), (CollisionGetter)((CollisionGetter)newSpawn.m_14418_()), (BlockPos)((BlockPos)newSpawn.m_14419_()), (boolean)true);
        if (tpPos == null) {
            serverPlayerEntity.m_8999_(newSpawnDimension, (double)newSpawnPos.m_123341_(), (double)newSpawnPos.m_123342_(), (double)newSpawnPos.m_123343_(), this.entity.m_146909_(), this.entity.m_146908_());
            Apoli.LOGGER.warn("Power {} could not find a suitable spawnpoint for {}! Teleporting to the desired location directly...", (Object)this.getType().getIdentifier(), (Object)this.entity.m_6302_());
        } else {
            serverPlayerEntity.m_8999_(newSpawnDimension, tpPos.f_82479_, tpPos.f_82480_, tpPos.f_82481_, this.entity.m_146909_(), this.entity.m_146908_());
        }
    }

    public Tuple<ServerLevel, BlockPos> getSpawn(boolean isSpawnObstructed) {
        LivingEntity livingEntity;
        if (this.entity.m_9236_().f_46443_ || !((livingEntity = this.entity) instanceof Player)) {
            return null;
        }
        Player playerEntity = (Player)livingEntity;
        ServerPlayer serverPlayerEntity = (ServerPlayer)playerEntity;
        MinecraftServer server = serverPlayerEntity.m_20194_();
        if (server == null) {
            return null;
        }
        ServerLevel overworldDimension = server.m_129880_(Level.f_46428_);
        if (overworldDimension == null) {
            return null;
        }
        ServerLevel targetDimension = server.m_129880_(this.dimension);
        if (targetDimension == null) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at dimension \"{}\" as it's not registered! Falling back to default spawnpoint...", (Object)this.getType().getIdentifier(), (Object)this.entity.m_6302_(), (Object)this.dimension.m_135782_());
            return null;
        }
        int center = targetDimension.m_143344_() / 2;
        int range = 64;
        AtomicReference modifiedSpawnPos = new AtomicReference();
        BlockPos regularSpawnBlockPos = overworldDimension.m_220360_();
        BlockPos.MutableBlockPos modifiedSpawnBlockPos = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos dimensionSpawnPos = this.spawnStrategy.apply(regularSpawnBlockPos, center, this.dimensionDistanceMultiplier).m_122032_();
        this.getBiomePos(targetDimension, (BlockPos)dimensionSpawnPos).ifPresent(arg_0 -> ((BlockPos.MutableBlockPos)dimensionSpawnPos).m_122190_(arg_0));
        this.getSpawnPos(targetDimension, (BlockPos)dimensionSpawnPos, range).ifPresent(modifiedSpawnPos::set);
        if (modifiedSpawnPos.get() == null) {
            return null;
        }
        Vec3 msp = (Vec3)modifiedSpawnPos.get();
        modifiedSpawnBlockPos.m_122169_(msp.f_82479_, msp.f_82480_, msp.f_82481_);
        targetDimension.m_7726_().m_8387_(TicketType.f_9442_, new ChunkPos((BlockPos)modifiedSpawnBlockPos), 11, (Object)Unit.INSTANCE);
        return new Tuple((Object)targetDimension, (Object)modifiedSpawnBlockPos);
    }

    private Optional<BlockPos> getBiomePos(ServerLevel targetDimension, BlockPos originPos) {
        if (this.biomeId == null) {
            return Optional.empty();
        }
        Optional targetBiome = targetDimension.m_9598_().m_175515_(Registries.f_256952_).m_6612_(this.biomeId);
        if (targetBiome.isEmpty()) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at biome \"{}\" as it's not registered in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.m_6302_(), (Object)this.biomeId, (Object)this.dimension.m_135782_());
            return Optional.empty();
        }
        Pair targetBiomePos = targetDimension.m_215069_(biome -> biome.m_203334_() == targetBiome.get(), originPos, 6400, 8, 8);
        if (targetBiomePos != null) {
            return Optional.of((BlockPos)targetBiomePos.getFirst());
        }
        Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at biome \"{}\" as it couldn't be found in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.m_6302_(), (Object)this.biomeId, (Object)this.dimension.m_135782_());
        return Optional.empty();
    }

    private Optional<Tuple<BlockPos, Structure>> getStructurePos(Level world, ResourceKey<Structure> structure, TagKey<Structure> structureTag, ResourceKey<Level> dimension) {
        MinecraftServer server;
        Registry structureRegistry = world.m_9598_().m_175515_(Registries.f_256944_);
        HolderSet structureRegistryEntryList = null;
        Object structureTagOrName = "";
        if (structure != null) {
            Optional entry = structureRegistry.m_203636_(structure);
            if (entry.isPresent()) {
                structureRegistryEntryList = HolderSet.m_205809_((Holder[])new Holder[]{(Holder)entry.get()});
            }
            structureTagOrName = structure.m_135782_().toString();
        }
        if (structureRegistryEntryList == null) {
            Optional entryList = structureRegistry.m_203431_(structureTag);
            if (entryList.isPresent()) {
                structureRegistryEntryList = (HolderSet)entryList.get();
            }
            structureTagOrName = "#" + structureTag.f_203868_().toString();
        }
        if ((server = this.entity.m_20194_()) == null) {
            return Optional.empty();
        }
        ServerLevel serverWorld = server.m_129880_(dimension);
        if (serverWorld == null) {
            return Optional.empty();
        }
        BlockPos center = new BlockPos(0, 70, 0);
        Pair structurePos = serverWorld.m_7726_().m_8481_().m_223037_(serverWorld, structureRegistryEntryList, center, 100, false);
        if (structurePos == null) {
            Apoli.LOGGER.warn("Power {} could not set {}'s spawnpoint at structure \"{}\" as it couldn't be found in dimension \"{}\".", (Object)this.getType().getIdentifier(), (Object)this.entity.m_6302_(), structureTagOrName, (Object)dimension.m_135782_());
            return Optional.empty();
        }
        return Optional.of(new Tuple((Object)((BlockPos)structurePos.getFirst()), (Object)((Structure)((Holder)structurePos.getSecond()).m_203334_())));
    }

    private Optional<Vec3> getSpawnPos(ServerLevel targetDimension, BlockPos originPos, int range) {
        if (this.structure == null) {
            return this.getValidSpawn(targetDimension, originPos, range);
        }
        Optional<Tuple<BlockPos, Structure>> targetStructure = this.getStructurePos((Level)targetDimension, this.structure, null, this.dimension);
        if (targetStructure.isEmpty()) {
            return Optional.empty();
        }
        BlockPos targetStructurePos = (BlockPos)targetStructure.get().m_14418_();
        ChunkPos targetStructureChunkPos = new ChunkPos(targetStructurePos.m_123341_() >> 4, targetStructurePos.m_123343_() >> 4);
        StructureStart targetStructureStart = targetDimension.m_215010_().m_220512_(SectionPos.m_123196_((ChunkPos)targetStructureChunkPos, (int)0), (Structure)targetStructure.get().m_14419_(), (StructureAccess)targetDimension.m_46865_(targetStructurePos));
        if (targetStructureStart == null) {
            return Optional.empty();
        }
        BlockPos targetStructureCenter = new BlockPos((Vec3i)targetStructureStart.m_73601_().m_162394_());
        return this.getValidSpawn(targetDimension, targetStructureCenter, range);
    }

    private Optional<Vec3> getValidSpawn(ServerLevel targetDimension, BlockPos startPos, int range) {
        int dx = 1;
        int dz = 0;
        int segmentLength = 1;
        int center = startPos.m_123342_();
        BlockPos.MutableBlockPos mutableStartPos = startPos.m_122032_();
        int x = startPos.m_123341_();
        int z = startPos.m_123343_();
        int segmentPassed = 0;
        int upOffset = 0;
        int downOffset = 0;
        int maxY = targetDimension.m_143344_();
        int minY = ((DimensionType)targetDimension.m_204156_().m_203334_()).f_156647_();
        while (upOffset < maxY || downOffset > minY) {
            for (int steps = 0; steps < range; ++steps) {
                mutableStartPos.m_142451_(x += dx);
                mutableStartPos.m_142443_(z += dz);
                ++segmentPassed;
                mutableStartPos.m_142448_(center + upOffset);
                Vec3 spawnPos = DismountHelper.m_38441_((EntityType)this.entity.m_6095_(), (CollisionGetter)targetDimension, (BlockPos)mutableStartPos, (boolean)true);
                if (spawnPos != null) {
                    return Optional.of(spawnPos);
                }
                mutableStartPos.m_142448_(center + downOffset);
                spawnPos = DismountHelper.m_38441_((EntityType)this.entity.m_6095_(), (CollisionGetter)targetDimension, (BlockPos)mutableStartPos, (boolean)true);
                if (spawnPos != null) {
                    return Optional.of(spawnPos);
                }
                if (segmentPassed != segmentLength) continue;
                segmentPassed = 0;
                int bdx = dx;
                dx = -dz;
                dz = bdx;
                if (dz != 0) continue;
                ++segmentLength;
            }
            if (upOffset < maxY) {
                ++upOffset;
            }
            if (downOffset <= minY) continue;
            --downOffset;
        }
        return Optional.empty();
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_player_spawn"), new SerializableData().add("dimension", SerializableDataTypes.DIMENSION).add("dimension_distance_multiplier", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.0f)).add("biome", SerializableDataTypes.IDENTIFIER, null).add("spawn_strategy", SerializableDataType.enumValue(SpawnStrategy.class), (Object)SpawnStrategy.DEFAULT).add("structure", SerializableDataType.registryKey((ResourceKey)Registries.f_256944_), null).add("respawn_sound", SerializableDataTypes.SOUND_EVENT, null), data -> (powerType, livingEntity) -> new ModifyPlayerSpawnPower((PowerType<?>)powerType, (LivingEntity)livingEntity, (ResourceKey<Level>)((ResourceKey)data.get("dimension")), ((Float)data.get("dimension_distance_multiplier")).floatValue(), (ResourceLocation)data.get("biome"), (SpawnStrategy)((Object)((Object)((Object)data.get("spawn_strategy")))), (ResourceKey<Structure>)((ResourceKey)data.get("structure")), (SoundEvent)data.get("respawn_sound"))).allowCondition();
    }

    private static enum SpawnStrategy {
        CENTER((TriFunction<BlockPos, Integer, Float, BlockPos>)((TriFunction)(blockPos, center, multiplier) -> new BlockPos(0, center.intValue(), 0))),
        DEFAULT((TriFunction<BlockPos, Integer, Float, BlockPos>)((TriFunction)(blockPos, center, multiplier) -> {
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            if (multiplier.floatValue() != 0.0f) {
                mut.m_122169_((double)((float)blockPos.m_123341_() * multiplier.floatValue()), (double)blockPos.m_123342_(), (double)((float)blockPos.m_123343_() * multiplier.floatValue()));
            } else {
                mut.m_122190_((Vec3i)blockPos);
            }
            return mut;
        }));

        final TriFunction<BlockPos, Integer, Float, BlockPos> strategyApplier;

        private SpawnStrategy(TriFunction<BlockPos, Integer, Float, BlockPos> strategyApplier) {
            this.strategyApplier = strategyApplier;
        }

        public BlockPos apply(BlockPos blockPos, int center, float multiplier) {
            return (BlockPos)this.strategyApplier.apply((Object)blockPos, (Object)center, (Object)Float.valueOf(multiplier));
        }
    }
}

