/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;

public class ModifyHarvestPower
extends Power {
    private final Predicate<BlockInWorld> predicate;
    private boolean allow;

    public ModifyHarvestPower(PowerType<?> type, LivingEntity entity, Predicate<BlockInWorld> predicate, boolean allow) {
        super(type, entity);
        this.predicate = predicate;
        this.allow = allow;
    }

    public boolean doesApply(BlockPos pos) {
        BlockInWorld cbp = new BlockInWorld((LevelReader)this.entity.m_9236_(), pos, true);
        return this.predicate.test(cbp);
    }

    public boolean doesApply(BlockInWorld pos) {
        return this.predicate.test(pos);
    }

    public boolean isHarvestAllowed() {
        return this.allow;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_harvest"), new SerializableData().add("block_condition", ApoliDataTypes.BLOCK_CONDITION, null).add("allow", SerializableDataTypes.BOOLEAN), data -> (type, player) -> new ModifyHarvestPower((PowerType<?>)type, (LivingEntity)player, data.isPresent("block_condition") ? (ConditionFactory.Instance)data.get("block_condition") : cbp -> true, data.getBoolean("allow"))).allowCondition();
    }
}

