/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ModifyDamageTakenPower
extends ValueModifyingPower {
    private final Predicate<Tuple<DamageSource, Float>> condition;
    private final Predicate<Tuple<Entity, Entity>> biEntityCondition;
    private Consumer<Entity> attackerAction;
    private Consumer<Entity> selfAction;
    private Consumer<Tuple<Entity, Entity>> biEntityAction;
    private Predicate<Entity> applyArmorCondition;
    private Predicate<Entity> damageArmorCondition;

    public ModifyDamageTakenPower(PowerType<?> type, LivingEntity entity, Predicate<Tuple<DamageSource, Float>> condition, Predicate<Tuple<Entity, Entity>> biEntityCondition) {
        super(type, entity);
        this.condition = condition;
        this.biEntityCondition = biEntityCondition;
    }

    public void setApplyArmorCondition(Predicate<Entity> applyArmorCondition) {
        this.applyArmorCondition = applyArmorCondition;
    }

    public void setDamageArmorCondition(Predicate<Entity> damageArmorCondition) {
        this.damageArmorCondition = damageArmorCondition;
    }

    public boolean modifiesArmorApplicance() {
        return this.applyArmorCondition != null;
    }

    public boolean shouldApplyArmor() {
        return this.applyArmorCondition != null && this.applyArmorCondition.test((Entity)this.entity);
    }

    public boolean modifiesArmorDamaging() {
        return this.damageArmorCondition != null;
    }

    public boolean shouldDamageArmor() {
        return this.damageArmorCondition != null && this.damageArmorCondition.test((Entity)this.entity);
    }

    public boolean doesApply(DamageSource source, float damageAmount) {
        return source.m_7639_() == null ? this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount))) && this.biEntityCondition == null : this.condition.test((Tuple<DamageSource, Float>)new Tuple((Object)source, (Object)Float.valueOf(damageAmount))) && (this.biEntityCondition == null || this.biEntityCondition.test((Tuple<Entity, Entity>)new Tuple((Object)source.m_7639_(), (Object)this.entity)));
    }

    public void setAttackerAction(Consumer<Entity> attackerAction) {
        this.attackerAction = attackerAction;
    }

    public void setSelfAction(Consumer<Entity> selfAction) {
        this.selfAction = selfAction;
    }

    public void setBiEntityAction(Consumer<Tuple<Entity, Entity>> biEntityAction) {
        this.biEntityAction = biEntityAction;
    }

    public void executeActions(Entity attacker) {
        if (this.selfAction != null) {
            this.selfAction.accept((Entity)this.entity);
        }
        if (this.attackerAction != null) {
            this.attackerAction.accept(attacker);
        }
        if (this.biEntityAction != null) {
            this.biEntityAction.accept((Tuple<Entity, Entity>)new Tuple((Object)attacker, (Object)this.entity));
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("modify_damage_taken"), new SerializableData().add("damage_condition", ApoliDataTypes.DAMAGE_CONDITION, null).add("bientity_condition", ApoliDataTypes.BIENTITY_CONDITION, null).add("modifier", Modifier.DATA_TYPE, null).add("modifiers", Modifier.LIST_TYPE, null).add("self_action", ApoliDataTypes.ENTITY_ACTION, null).add("attacker_action", ApoliDataTypes.ENTITY_ACTION, null).add("bientity_action", ApoliDataTypes.BIENTITY_ACTION, null).add("apply_armor_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("damage_armor_condition", ApoliDataTypes.ENTITY_CONDITION, null), data -> (type, player) -> {
            ModifyDamageTakenPower power = new ModifyDamageTakenPower((PowerType<?>)type, (LivingEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("bientity_condition"));
            data.ifPresent("modifier", power::addModifier);
            data.ifPresent("modifiers", mods -> mods.forEach(power::addModifier));
            if (data.isPresent("bientity_action")) {
                power.setBiEntityAction((Consumer)data.get("bientity_action"));
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("attacker_action")) {
                power.setAttackerAction((Consumer)data.get("attacker_action"));
            }
            data.ifPresent("apply_armor_condition", power::setApplyArmorCondition);
            data.ifPresent("damage_armor_condition", power::setDamageArmorCondition);
            return power;
        }).allowCondition();
    }
}

