/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataType;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.DispenserMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class InventoryPower
extends Power
implements Active,
Container {
    private final NonNullList<ItemStack> container;
    private final MutableComponent containerTitle;
    private final MenuConstructor containerScreen;
    private final Predicate<ItemStack> dropOnDeathFilter;
    private final boolean shouldDropOnDeath;
    private final boolean recoverable;
    private final int containerSize;
    private Active.Key key;

    public InventoryPower(PowerType<?> type, LivingEntity entity, String containerTitle, ContainerType containerType, boolean shouldDropOnDeath, Predicate<ItemStack> dropOnDeathFilter, boolean recoverable) {
        super(type, entity);
        switch (containerType.ordinal()) {
            case 1: {
                this.containerSize = 54;
                this.containerScreen = (i, playerInventory, playerEntity) -> new ChestMenu(MenuType.f_39962_, i, playerInventory, (Container)this, 6);
                break;
            }
            case 0: {
                this.containerSize = 27;
                this.containerScreen = (i, playerInventory, playerEntity) -> new ChestMenu(MenuType.f_39959_, i, playerInventory, (Container)this, 3);
                break;
            }
            case 4: {
                this.containerSize = 5;
                this.containerScreen = (i, playerInventory, playerEntity) -> new HopperMenu(i, playerInventory, (Container)this);
                break;
            }
            default: {
                this.containerSize = 9;
                this.containerScreen = (i, playerInventory, playerEntity) -> new DispenserMenu(i, playerInventory, (Container)this);
            }
        }
        this.container = NonNullList.m_122780_((int)this.containerSize, (Object)ItemStack.f_41583_);
        this.containerTitle = Component.m_237115_((String)containerTitle);
        this.shouldDropOnDeath = shouldDropOnDeath;
        this.dropOnDeathFilter = dropOnDeathFilter;
        this.recoverable = recoverable;
    }

    @Override
    public void onLost() {
        if (this.recoverable) {
            this.dropItemsOnLost();
        }
    }

    @Override
    public void onUse() {
        LivingEntity livingEntity;
        if (!this.isActive()) {
            return;
        }
        if (!this.entity.m_9236_().f_46443_ && (livingEntity = this.entity) instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            playerEntity.m_5893_((MenuProvider)new SimpleMenuProvider(this.containerScreen, (Component)this.containerTitle));
        }
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)tag, this.container);
        return tag;
    }

    @Override
    public void fromTag(Tag tag) {
        ContainerHelper.m_18980_((CompoundTag)((CompoundTag)tag), this.container);
    }

    public int m_6643_() {
        return this.containerSize;
    }

    public boolean m_7983_() {
        return this.container.isEmpty();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.container.get(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return ((ItemStack)this.container.get(slot)).m_41620_(amount);
    }

    public ItemStack m_8016_(int slot) {
        ItemStack stack = (ItemStack)this.container.get(slot);
        this.m_6836_(slot, ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.container.set(slot, (Object)stack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return player == this.entity;
    }

    public void m_6211_() {
        for (int i = 0; i < this.containerSize; ++i) {
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public NonNullList<ItemStack> getContainer() {
        return this.container;
    }

    public MutableComponent getContainerTitle() {
        return this.containerTitle;
    }

    public MenuConstructor getContainerScreen() {
        return this.containerScreen;
    }

    public boolean shouldDropOnDeath() {
        return this.shouldDropOnDeath;
    }

    public boolean shouldDropOnDeath(ItemStack stack) {
        return this.shouldDropOnDeath && this.dropOnDeathFilter.test(stack);
    }

    public void dropItemsOnDeath() {
        Player playerEntity = (Player)this.entity;
        for (int i = 0; i < this.containerSize; ++i) {
            ItemStack currentItemStack = this.m_8020_(i);
            if (!this.shouldDropOnDeath(currentItemStack)) continue;
            if (!currentItemStack.m_41619_() && EnchantmentHelper.m_44924_((ItemStack)currentItemStack)) {
                this.m_8016_(i);
                continue;
            }
            playerEntity.m_7197_(currentItemStack, true, false);
            this.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public void dropItemsOnLost() {
        Player playerEntity = (Player)this.entity;
        for (int i = 0; i < this.containerSize; ++i) {
            ItemStack currentItemStack = this.m_8020_(i);
            playerEntity.m_150109_().m_150079_(currentItemStack);
        }
    }

    @Override
    public Active.Key getKey() {
        return this.key;
    }

    @Override
    public void setKey(Active.Key key) {
        this.key = key;
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("inventory"), new SerializableData().add("title", SerializableDataTypes.STRING, (Object)"container.inventory").add("container_type", SerializableDataType.enumValue(ContainerType.class), (Object)ContainerType.DROPPER).add("drop_on_death", SerializableDataTypes.BOOLEAN, (Object)false).add("drop_on_death_filter", ApoliDataTypes.ITEM_CONDITION, null).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()).add("recoverable", SerializableDataTypes.BOOLEAN, (Object)true), data -> (powerType, livingEntity) -> {
            InventoryPower inventoryPower = new InventoryPower((PowerType<?>)powerType, (LivingEntity)livingEntity, data.getString("title"), (ContainerType)((Object)((Object)((Object)data.get("container_type")))), data.getBoolean("drop_on_death"), data.isPresent("drop_on_death_filter") ? (Predicate)data.get("drop_on_death_filter") : itemStack -> true, data.getBoolean("recoverable"));
            inventoryPower.setKey((Active.Key)data.get("key"));
            return inventoryPower;
        }).allowCondition();
    }

    public static enum ContainerType {
        CHEST,
        DOUBLE_CHEST,
        DROPPER,
        DISPENSER,
        HOPPER;

    }
}

