/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Active;
import io.github.apace100.apoli.power.ActiveCooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireProjectilePower
extends ActiveCooldownPower {
    private final EntityType<?> entityType;
    private final int projectileCount;
    private final int interval;
    private final int startDelay;
    private final float speed;
    private final float divergence;
    private final SoundEvent soundEvent;
    private final CompoundTag tag;
    private final Consumer<Entity> projectileAction;
    private final Consumer<Entity> shooterAction;
    private boolean isFiringProjectiles;
    private boolean finishedStartDelay;
    private int shotProjectiles;

    public FireProjectilePower(PowerType<?> type, LivingEntity entity, int cooldownDuration, HudRender hudRender, EntityType<?> entityType, int projectileCount, int interval, int startDelay, float speed, float divergence, SoundEvent soundEvent, CompoundTag tag, Consumer<Entity> projectileAction, Consumer<Entity> shooterAction) {
        super(type, entity, cooldownDuration, hudRender, null);
        this.entityType = entityType;
        this.projectileCount = projectileCount;
        this.interval = interval;
        this.startDelay = startDelay;
        this.speed = speed;
        this.divergence = divergence;
        this.soundEvent = soundEvent;
        this.tag = tag;
        this.projectileAction = projectileAction;
        this.shooterAction = shooterAction;
        this.setTicking(true);
    }

    @Override
    public void onUse() {
        if (this.canUse()) {
            this.isFiringProjectiles = true;
            this.use();
        }
    }

    @Override
    public Tag toTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128356_("LastUseTime", this.lastUseTime);
        nbt.m_128405_("ShotProjectiles", this.shotProjectiles);
        nbt.m_128379_("FinishedStartDelay", this.finishedStartDelay);
        nbt.m_128379_("IsFiringProjectiles", this.isFiringProjectiles);
        return nbt;
    }

    @Override
    public void fromTag(Tag tag) {
        if (tag instanceof LongTag) {
            this.lastUseTime = ((LongTag)tag).m_7046_();
        } else {
            this.lastUseTime = ((CompoundTag)tag).m_128454_("LastUseTime");
            this.shotProjectiles = ((CompoundTag)tag).m_128451_("ShotProjectiles");
            this.finishedStartDelay = ((CompoundTag)tag).m_128471_("FinishedStartDelay");
            this.isFiringProjectiles = ((CompoundTag)tag).m_128471_("IsFiringProjectiles");
        }
    }

    @Override
    public void tick() {
        if (this.isFiringProjectiles) {
            if (!this.finishedStartDelay && this.startDelay == 0) {
                this.finishedStartDelay = true;
            }
            if (!this.finishedStartDelay && (this.entity.m_20193_().m_46467_() - this.lastUseTime) % (long)this.startDelay == 0L) {
                this.finishedStartDelay = true;
                ++this.shotProjectiles;
                if (this.shotProjectiles <= this.projectileCount) {
                    if (this.soundEvent != null) {
                        this.entity.m_9236_().m_6263_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.soundEvent, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.entity.m_217043_().m_188501_() * 0.4f + 0.8f));
                    }
                    if (!this.entity.m_9236_().f_46443_) {
                        this.fireProjectile();
                    }
                } else {
                    this.shotProjectiles = 0;
                    this.finishedStartDelay = false;
                    this.isFiringProjectiles = false;
                }
            } else if (this.interval == 0 && this.finishedStartDelay) {
                if (this.soundEvent != null) {
                    this.entity.m_9236_().m_6263_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.soundEvent, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.entity.m_217043_().m_188501_() * 0.4f + 0.8f));
                }
                if (!this.entity.m_9236_().f_46443_) {
                    while (this.shotProjectiles < this.projectileCount) {
                        this.fireProjectile();
                        ++this.shotProjectiles;
                    }
                }
                this.shotProjectiles = 0;
                this.finishedStartDelay = false;
                this.isFiringProjectiles = false;
            } else if (this.finishedStartDelay && (this.entity.m_20193_().m_46467_() - this.lastUseTime) % (long)this.interval == 0L) {
                ++this.shotProjectiles;
                if (this.shotProjectiles <= this.projectileCount) {
                    if (this.soundEvent != null) {
                        this.entity.m_9236_().m_6263_(null, this.entity.m_20185_(), this.entity.m_20186_(), this.entity.m_20189_(), this.soundEvent, SoundSource.NEUTRAL, 0.5f, 0.4f / (this.entity.m_217043_().m_188501_() * 0.4f + 0.8f));
                    }
                    if (!this.entity.m_9236_().f_46443_) {
                        this.fireProjectile();
                    }
                } else {
                    this.shotProjectiles = 0;
                    this.finishedStartDelay = false;
                    this.isFiringProjectiles = false;
                }
            }
        }
    }

    private void fireProjectile() {
        if (this.entityType == null || this.entity.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)this.entity.m_9236_();
        float yaw = this.entity.m_146908_();
        float pitch = this.entity.m_146909_();
        Optional<Entity> opt$entityToSpawn = MiscUtil.getEntityWithPassengers((Level)serverWorld, this.entityType, this.tag, this.entity.m_20182_().m_82520_(0.0, (double)this.entity.m_20236_(this.entity.m_20089_()), 0.0), yaw, pitch);
        if (opt$entityToSpawn.isEmpty()) {
            return;
        }
        Vec3 rotationVector = this.entity.m_20154_();
        Vec3 velocity = this.entity.m_20184_();
        Entity entityToSpawn = opt$entityToSpawn.get();
        RandomSource random = serverWorld.m_213780_();
        if (entityToSpawn instanceof Projectile) {
            Projectile projectileToSpawn = (Projectile)entityToSpawn;
            if (projectileToSpawn instanceof AbstractHurtingProjectile) {
                AbstractHurtingProjectile explosiveProjectileToSpawn = (AbstractHurtingProjectile)projectileToSpawn;
                explosiveProjectileToSpawn.f_36813_ = rotationVector.f_82479_ * (double)this.speed;
                explosiveProjectileToSpawn.f_36814_ = rotationVector.f_82480_ * (double)this.speed;
                explosiveProjectileToSpawn.f_36815_ = rotationVector.f_82481_ * (double)this.speed;
            }
            projectileToSpawn.m_5602_((Entity)this.entity);
            projectileToSpawn.m_37251_((Entity)this.entity, pitch, yaw, 0.0f, this.speed, this.divergence);
        } else {
            float f = (float)Math.PI / 180;
            double g = 0.0075f;
            float h = -Mth.m_14031_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
            float i = -Mth.m_14031_((float)(pitch * f));
            float j = Mth.m_14089_((float)(yaw * f)) * Mth.m_14089_((float)(pitch * f));
            Vec3 vec3d = new Vec3((double)h, (double)i, (double)j).m_82541_().m_82520_(random.m_188583_() * g * (double)this.divergence, random.m_188583_() * g * (double)this.divergence, random.m_188583_() * g * (double)this.divergence).m_82490_((double)this.speed);
            entityToSpawn.m_20256_(vec3d);
            entityToSpawn.m_5997_(velocity.f_82479_, this.entity.m_20096_() ? 0.0 : velocity.f_82480_, velocity.f_82481_);
        }
        serverWorld.m_8860_(entityToSpawn);
        if (this.projectileAction != null) {
            this.projectileAction.accept(entityToSpawn);
        }
        if (this.shooterAction != null) {
            this.shooterAction.accept((Entity)this.entity);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("fire_projectile"), new SerializableData().add("cooldown", SerializableDataTypes.INT, (Object)1).add("count", SerializableDataTypes.INT, (Object)1).add("interval", SerializableDataTypes.INT, (Object)0).add("start_delay", SerializableDataTypes.INT, (Object)0).add("speed", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.5f)).add("divergence", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)).add("sound", SerializableDataTypes.SOUND_EVENT, null).add("entity_type", SerializableDataTypes.ENTITY_TYPE).add("hud_render", ApoliDataTypes.HUD_RENDER, (Object)HudRender.DONT_RENDER).add("tag", SerializableDataTypes.NBT, null).add("key", ApoliDataTypes.BACKWARDS_COMPATIBLE_KEY, (Object)new Active.Key()).add("projectile_action", ApoliDataTypes.ENTITY_ACTION, null).add("shooter_action", ApoliDataTypes.ENTITY_ACTION, null), data -> (powerType, livingEntity) -> {
            FireProjectilePower fpp = new FireProjectilePower((PowerType<?>)powerType, (LivingEntity)livingEntity, (Integer)data.get("cooldown"), (HudRender)data.get("hud_render"), (EntityType<?>)((EntityType)data.get("entity_type")), (Integer)data.get("count"), (Integer)data.get("interval"), (Integer)data.get("start_delay"), ((Float)data.get("speed")).floatValue(), ((Float)data.get("divergence")).floatValue(), (SoundEvent)data.get("sound"), (CompoundTag)data.get("tag"), (Consumer)data.get("projectile_action"), (Consumer)data.get("shooter_action"));
            fpp.setKey((Active.Key)data.get("key"));
            return fpp;
        }).allowCondition();
    }
}

