/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ElytraFlightPower
extends Power {
    private final boolean renderElytra;
    private final ResourceLocation textureLocation;

    public ElytraFlightPower(PowerType<?> type, LivingEntity entity, boolean renderElytra, ResourceLocation textureLocation) {
        super(type, entity);
        this.renderElytra = renderElytra;
        this.textureLocation = textureLocation;
    }

    public boolean shouldRenderElytra() {
        return this.renderElytra;
    }

    public ResourceLocation getTextureLocation() {
        return this.textureLocation;
    }

    public static PowerFactory createFactory() {
        EntityElytraEvents.CUSTOM.register((livingEntity, b) -> PowerHolderComponent.hasPower((Entity)livingEntity, ElytraFlightPower.class));
        return new PowerFactory(Apoli.identifier("elytra_flight"), new SerializableData().add("render_elytra", SerializableDataTypes.BOOLEAN).add("texture_location", SerializableDataTypes.IDENTIFIER, null), data -> (type, player) -> new ElytraFlightPower((PowerType<?>)type, (LivingEntity)player, data.getBoolean("render_elytra"), data.getId("texture_location"))).allowCondition();
    }
}

