/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.data.DamageSourceDescription;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.util.MiscUtil;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class DamageOverTimePower
extends Power {
    public static final ResourceKey<DamageType> GENERIC_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)Apoli.identifier("damage_over_time"));
    private final int damageTickInterval;
    private final int beginDamageIn;
    private final float damageAmountEasy;
    private final float damageAmount;
    private final DamageSourceDescription damageSourceDescription;
    private final ResourceKey<DamageType> damageType;
    private final Enchantment protectingEnchantment;
    private final float protectionEffectiveness;
    private int outOfDamageTicks;
    private int inDamageTicks;
    private DamageSource damageSource;

    public DamageOverTimePower(PowerType<?> type, LivingEntity entity, int beginDamageIn, int damageInterval, float damageAmountEasy, float damageAmount, DamageSourceDescription damageSourceDescription, ResourceKey<DamageType> damageType, Enchantment protectingEnchantment, float protectionEffectiveness) {
        super(type, entity);
        this.damageSourceDescription = damageSourceDescription;
        this.damageType = damageType;
        this.beginDamageIn = beginDamageIn;
        this.damageAmount = damageAmount;
        this.damageAmountEasy = damageAmountEasy;
        this.damageTickInterval = damageInterval;
        this.protectingEnchantment = protectingEnchantment;
        this.protectionEffectiveness = protectionEffectiveness;
        this.setTicking(true);
    }

    public int getDamageBegin() {
        int prot = this.getProtection();
        int delay = (int)(Math.pow(prot * 2, 1.3) * (double)this.protectionEffectiveness);
        return this.beginDamageIn + delay * 20;
    }

    @Override
    public void tick() {
        if (this.isActive()) {
            this.doDamage();
        } else {
            this.resetDamage();
        }
    }

    public void doDamage() {
        this.outOfDamageTicks = 0;
        if (this.inDamageTicks - this.getDamageBegin() >= 0 && (this.inDamageTicks - this.getDamageBegin()) % this.damageTickInterval == 0) {
            DamageSource source = this.getDamageSource(this.entity.m_269291_());
            this.entity.m_6469_(source, this.entity.m_9236_().m_46791_() == Difficulty.EASY ? this.damageAmountEasy : this.damageAmount);
        }
        ++this.inDamageTicks;
    }

    private DamageSource getDamageSource(DamageSources damageSources) {
        if (this.damageSource == null) {
            this.damageSource = MiscUtil.createDamageSource(damageSources, this.damageSourceDescription, this.damageType);
        }
        return this.damageSource;
    }

    public void resetDamage() {
        if (this.outOfDamageTicks >= 20) {
            this.inDamageTicks = 0;
        } else {
            ++this.outOfDamageTicks;
        }
    }

    @Override
    public void onRespawn() {
        this.inDamageTicks = 0;
        this.outOfDamageTicks = 0;
    }

    private int getProtection() {
        if (this.protectingEnchantment == null) {
            return 0;
        }
        Map enchantedItems = this.protectingEnchantment.m_44684_(this.entity);
        Collection iterable = enchantedItems.values();
        int i = 0;
        int items = 0;
        for (ItemStack itemStack : iterable) {
            int enchLevel = EnchantmentHelper.m_44843_((Enchantment)this.protectingEnchantment, (ItemStack)itemStack);
            i += enchLevel;
            if (enchLevel <= 0) continue;
            ++items;
        }
        return i + items;
    }

    @Override
    public Tag toTag() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("InDamage", this.inDamageTicks);
        nbt.m_128405_("OutDamage", this.outOfDamageTicks);
        return nbt;
    }

    @Override
    public void fromTag(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            this.inDamageTicks = nbt.m_128451_("InDamage");
            this.outOfDamageTicks = nbt.m_128451_("OutDamage");
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("damage_over_time"), new SerializableData().add("interval", SerializableDataTypes.INT, (Object)20).addFunctionedDefault("onset_delay", SerializableDataTypes.INT, data -> data.getInt("interval")).add("damage", SerializableDataTypes.FLOAT).addFunctionedDefault("damage_easy", SerializableDataTypes.FLOAT, data -> Float.valueOf(data.getFloat("damage"))).add("damage_source", ApoliDataTypes.DAMAGE_SOURCE_DESCRIPTION, null).add("damage_type", SerializableDataTypes.DAMAGE_TYPE, GENERIC_DAMAGE).add("protection_enchantment", SerializableDataTypes.ENCHANTMENT, null).add("protection_effectiveness", SerializableDataTypes.FLOAT, (Object)Float.valueOf(1.0f)), data -> (type, player) -> new DamageOverTimePower((PowerType<?>)type, (LivingEntity)player, data.getInt("onset_delay"), data.getInt("interval"), data.getFloat("damage_easy"), data.getFloat("damage"), (DamageSourceDescription)data.get("damage_source"), (ResourceKey<DamageType>)((ResourceKey)data.get("damage_type")), (Enchantment)data.get("protection_enchantment"), data.getFloat("protection_effectiveness"))).allowCondition();
    }
}

