/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.condition.ConditionFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.HashMap;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class ConditionedRestrictArmorPower
extends Power {
    private final HashMap<EquipmentSlot, Predicate<ItemStack>> armorConditions;
    private final int tickRate;

    public ConditionedRestrictArmorPower(PowerType<?> type, LivingEntity entity, HashMap<EquipmentSlot, Predicate<ItemStack>> armorConditions, int tickRate) {
        super(type, entity);
        this.armorConditions = armorConditions;
        this.setTicking(true);
        this.tickRate = tickRate;
    }

    public boolean canEquip(ItemStack itemStack, EquipmentSlot slot) {
        return !this.armorConditions.get(slot).test(itemStack);
    }

    @Override
    public void tick() {
        if (this.entity.f_19797_ % this.tickRate == 0 && this.isActive()) {
            for (EquipmentSlot slot : this.armorConditions.keySet()) {
                ItemStack equippedItem = this.entity.m_6844_(slot);
                if (equippedItem.m_41619_() || this.canEquip(equippedItem, slot)) continue;
                this.entity.m_5552_(equippedItem, this.entity.m_20236_(this.entity.m_20089_()));
                this.entity.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("conditioned_restrict_armor"), new SerializableData().add("head", ApoliDataTypes.ITEM_CONDITION, null).add("chest", ApoliDataTypes.ITEM_CONDITION, null).add("legs", ApoliDataTypes.ITEM_CONDITION, null).add("feet", ApoliDataTypes.ITEM_CONDITION, null).add("tick_rate", SerializableDataTypes.INT, (Object)80), data -> (type, player) -> {
            HashMap<EquipmentSlot, Predicate<ItemStack>> restrictions = new HashMap<EquipmentSlot, Predicate<ItemStack>>();
            if (data.isPresent("head")) {
                restrictions.put(EquipmentSlot.HEAD, (ConditionFactory.Instance)data.get("head"));
            }
            if (data.isPresent("chest")) {
                restrictions.put(EquipmentSlot.CHEST, (ConditionFactory.Instance)data.get("chest"));
            }
            if (data.isPresent("legs")) {
                restrictions.put(EquipmentSlot.LEGS, (ConditionFactory.Instance)data.get("legs"));
            }
            if (data.isPresent("feet")) {
                restrictions.put(EquipmentSlot.FEET, (ConditionFactory.Instance)data.get("feet"));
            }
            return new ConditionedRestrictArmorPower((PowerType<?>)type, (LivingEntity)player, restrictions, data.getInt("tick_rate"));
        }).allowCondition();
    }
}

