/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ClimbingPower
extends Power {
    private final Predicate<Entity> holdingCondition;
    private final boolean allowHolding;

    public ClimbingPower(PowerType<?> type, LivingEntity entity, Predicate<Entity> holdingCondition, boolean allowHolding) {
        super(type, entity);
        this.holdingCondition = holdingCondition != null ? holdingCondition : Entity::m_6144_;
        this.allowHolding = allowHolding;
    }

    public boolean canHold() {
        return this.allowHolding && this.holdingCondition.test((Entity)this.entity);
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("climbing"), new SerializableData().add("hold_condition", ApoliDataTypes.ENTITY_CONDITION, null).add("allow_holding", SerializableDataTypes.BOOLEAN, (Object)true), data -> (powerType, livingEntity) -> new ClimbingPower((PowerType<?>)powerType, (LivingEntity)livingEntity, (Predicate)data.get("hold_condition"), (Boolean)data.get("allow_holding"))).allowCondition();
    }
}

