/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.power;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.data.ApoliDataTypes;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.power.factory.action.ActionFactory;
import io.github.apace100.calio.data.SerializableData;
import java.util.function.Consumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class ActionOnCallbackPower
extends Power {
    private final Consumer<Entity> entityActionRespawned;
    private final Consumer<Entity> entityActionRemoved;
    private final Consumer<Entity> entityActionGained;
    private final Consumer<Entity> entityActionLost;
    private final Consumer<Entity> entityActionAdded;

    public ActionOnCallbackPower(PowerType<?> type, LivingEntity entity, Consumer<Entity> entityActionRespawned, Consumer<Entity> entityActionRemoved, Consumer<Entity> entityActionGained, Consumer<Entity> entityActionLost, Consumer<Entity> entityActionAdded) {
        super(type, entity);
        this.entityActionRespawned = entityActionRespawned;
        this.entityActionRemoved = entityActionRemoved;
        this.entityActionGained = entityActionGained;
        this.entityActionLost = entityActionLost;
        this.entityActionAdded = entityActionAdded;
    }

    @Override
    public void onRespawn() {
        if (this.entityActionRespawned != null) {
            this.entityActionRespawned.accept((Entity)this.entity);
        }
    }

    @Override
    public void onGained() {
        if (this.entityActionGained != null) {
            this.entityActionGained.accept((Entity)this.entity);
        }
    }

    @Override
    public void onRemoved() {
        if (this.entityActionRemoved != null) {
            this.entityActionRemoved.accept((Entity)this.entity);
        }
    }

    @Override
    public void onLost() {
        if (this.entityActionLost != null) {
            this.entityActionLost.accept((Entity)this.entity);
        }
    }

    @Override
    public void onAdded() {
        if (this.entityActionAdded != null) {
            this.entityActionAdded.accept((Entity)this.entity);
        }
    }

    public static PowerFactory createFactory() {
        return new PowerFactory(Apoli.identifier("action_on_callback"), new SerializableData().add("entity_action_respawned", ApoliDataTypes.ENTITY_ACTION, null).add("entity_action_removed", ApoliDataTypes.ENTITY_ACTION, null).add("entity_action_gained", ApoliDataTypes.ENTITY_ACTION, null).add("entity_action_lost", ApoliDataTypes.ENTITY_ACTION, null).add("entity_action_added", ApoliDataTypes.ENTITY_ACTION, null), data -> (type, player) -> new ActionOnCallbackPower((PowerType<?>)type, (LivingEntity)player, (ActionFactory.Instance)data.get("entity_action_respawned"), (ActionFactory.Instance)data.get("entity_action_removed"), (ActionFactory.Instance)data.get("entity_action_gained"), (ActionFactory.Instance)data.get("entity_action_lost"), (ActionFactory.Instance)data.get("entity_action_added"))).allowCondition();
    }
}

