/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.networking;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.MultiplePowerType;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.factory.PowerFactory;
import io.github.apace100.apoli.registry.ApoliRegistries;
import io.github.apace100.apoli.util.SyncStatusEffectsUtil;
import io.github.apace100.calio.SerializationHelper;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ModPacketsS2C {
    @Environment(value=EnvType.CLIENT)
    public static void register() {
        ClientLoginNetworking.registerGlobalReceiver((ResourceLocation)ModPackets.HANDSHAKE, ModPacketsS2C::handleHandshake);
        ClientPlayConnectionEvents.INIT.register((clientPlayNetworkHandler, minecraftClient) -> {
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.POWER_LIST, ModPacketsS2C::receivePowerList);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.SYNC_POWER, ModPacketsS2C::onPowerSync);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.PLAYER_MOUNT, ModPacketsS2C::onPlayerMount);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.PLAYER_DISMOUNT, ModPacketsS2C::onPlayerDismount);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.SET_ATTACKER, ModPacketsS2C::onSetAttacker);
            ClientPlayNetworking.registerReceiver((ResourceLocation)ModPackets.SYNC_STATUS_EFFECT, ModPacketsS2C::onStatusEffectSync);
        });
    }

    private static void onStatusEffectSync(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int targetId = packetByteBuf.readInt();
        SyncStatusEffectsUtil.UpdateType updateType = SyncStatusEffectsUtil.UpdateType.values()[packetByteBuf.readByte()];
        MobEffectInstance instance = null;
        if (updateType != SyncStatusEffectsUtil.UpdateType.CLEAR) {
            instance = SerializationHelper.readStatusEffect((FriendlyByteBuf)packetByteBuf);
        }
        MobEffectInstance finalInstance = instance;
        minecraftClient.execute(() -> {
            Entity target = clientPlayNetworkHandler.m_105147_().m_6815_(targetId);
            if (!(target instanceof LivingEntity)) {
                Apoli.LOGGER.warn("Received unknown target for status effect synchronization");
            } else {
                LivingEntity living = (LivingEntity)target;
                switch (updateType) {
                    case CLEAR: {
                        living.m_21221_().clear();
                        break;
                    }
                    case APPLY: 
                    case UPGRADE: {
                        living.m_21221_().put(finalInstance.m_19544_(), finalInstance);
                        break;
                    }
                    case REMOVE: {
                        living.m_21221_().remove(finalInstance.m_19544_());
                    }
                }
            }
        });
    }

    private static void onSetAttacker(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int targetId = packetByteBuf.readInt();
        boolean hasAttacker = packetByteBuf.readBoolean();
        int attackerId = 0;
        if (hasAttacker) {
            attackerId = packetByteBuf.readInt();
        }
        int finalAttackerId = attackerId;
        minecraftClient.execute(() -> {
            Entity target = clientPlayNetworkHandler.m_105147_().m_6815_(targetId);
            Entity attacker = null;
            if (hasAttacker) {
                attacker = clientPlayNetworkHandler.m_105147_().m_6815_(finalAttackerId);
            }
            if (!(target instanceof LivingEntity)) {
                Apoli.LOGGER.warn("Received unknown target");
            } else if (hasAttacker && !(attacker instanceof LivingEntity)) {
                Apoli.LOGGER.warn("Received unknown attacker");
            } else if (hasAttacker) {
                ((LivingEntity)target).m_6703_((LivingEntity)attacker);
            } else {
                ((LivingEntity)target).m_6703_(null);
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static CompletableFuture<FriendlyByteBuf> handleHandshake(Minecraft minecraftClient, ClientHandshakePacketListenerImpl clientLoginNetworkHandler, FriendlyByteBuf packetByteBuf, Consumer<GenericFutureListener<? extends Future<? super Void>>> genericFutureListenerConsumer) {
        FriendlyByteBuf buf = PacketByteBufs.create();
        buf.writeInt(Apoli.SEMVER.length);
        for (int i = 0; i < Apoli.SEMVER.length; ++i) {
            buf.writeInt(Apoli.SEMVER[i]);
        }
        return CompletableFuture.completedFuture(buf);
    }

    @Environment(value=EnvType.CLIENT)
    private static void receivePowerList(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int powerCount = packetByteBuf.readInt();
        HashMap<ResourceLocation, PowerType> factories = new HashMap<ResourceLocation, PowerType>();
        for (int i = 0; i < powerCount; ++i) {
            ResourceLocation powerId = packetByteBuf.m_130281_();
            ResourceLocation factoryId = packetByteBuf.m_130281_();
            try {
                PowerType type;
                PowerFactory factory = (PowerFactory)ApoliRegistries.POWER_FACTORY.m_7745_(factoryId);
                PowerFactory.Instance factoryInstance = factory.read(packetByteBuf);
                if (packetByteBuf.readBoolean()) {
                    type = new MultiplePowerType(powerId, factoryInstance);
                    int subPowerCount = packetByteBuf.m_130242_();
                    ArrayList<ResourceLocation> subPowers = new ArrayList<ResourceLocation>(subPowerCount);
                    for (int j = 0; j < subPowerCount; ++j) {
                        subPowers.add(packetByteBuf.m_130281_());
                    }
                    ((MultiplePowerType)type).setSubPowers(subPowers);
                } else {
                    type = new PowerType(powerId, factoryInstance);
                }
                type.setTranslationKeys(packetByteBuf.m_130277_(), packetByteBuf.m_130277_());
                if (packetByteBuf.readBoolean()) {
                    type.setHidden();
                }
                factories.put(powerId, type);
                continue;
            }
            catch (Exception e) {
                Apoli.LOGGER.error("Error while receiving \"" + String.valueOf(powerId) + "\" (factory: \"" + String.valueOf(factoryId) + "\"): " + e.getMessage());
                e.printStackTrace();
            }
        }
        minecraftClient.execute(() -> {
            PowerTypeRegistry.clear();
            factories.forEach(PowerTypeRegistry::register);
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerMount(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int mountingPlayerId = packetByteBuf.readInt();
        int mountedPlayerId = packetByteBuf.readInt();
        minecraftClient.execute(() -> {
            Entity mountingPlayer = clientPlayNetworkHandler.m_105147_().m_6815_(mountingPlayerId);
            Entity mountedPlayer = clientPlayNetworkHandler.m_105147_().m_6815_(mountedPlayerId);
            if (mountedPlayer == null) {
                Apoli.LOGGER.warn("Received passenger for unknown player");
            } else if (mountingPlayer == null) {
                Apoli.LOGGER.warn("Received unknown passenger for player");
            } else {
                boolean result = mountingPlayer.m_7998_(mountedPlayer, true);
                if (result) {
                    Apoli.LOGGER.info(mountingPlayer.m_5446_().getString() + " started riding " + mountedPlayer.m_5446_().getString());
                } else {
                    Apoli.LOGGER.warn(mountingPlayer.m_5446_().getString() + " failed to start riding " + mountedPlayer.m_5446_().getString());
                }
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPlayerDismount(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int dismountingPlayerId = packetByteBuf.readInt();
        minecraftClient.execute(() -> {
            Entity dismountingPlayer = clientPlayNetworkHandler.m_105147_().m_6815_(dismountingPlayerId);
            if (dismountingPlayer == null) {
                Apoli.LOGGER.warn("Unknown player tried to dismount");
            } else if (dismountingPlayer.m_20202_() instanceof Player) {
                dismountingPlayer.m_6038_();
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    private static void onPowerSync(Minecraft minecraftClient, ClientPacketListener clientPlayNetworkHandler, FriendlyByteBuf packetByteBuf, PacketSender packetSender) {
        int entityId = packetByteBuf.readInt();
        ResourceLocation powerId = packetByteBuf.m_130281_();
        CompoundTag powerNbtContainer = packetByteBuf.m_130260_();
        Tag powerNbt = powerNbtContainer.m_128423_("Data");
        minecraftClient.execute(() -> {
            if (!PowerTypeRegistry.contains(powerId)) {
                Apoli.LOGGER.warn("Received sync packet for unknown power type: " + String.valueOf(powerId));
                return;
            }
            Entity entity = clientPlayNetworkHandler.m_105147_().m_6815_(entityId);
            if (entity == null) {
                Apoli.LOGGER.warn("Received sync packet for unknown power holder.");
                return;
            }
            PowerType powerType = PowerTypeRegistry.get(powerId);
            PowerHolderComponent.KEY.maybeGet((Object)entity).ifPresentOrElse(phc -> {
                Object power = phc.getPower(powerType);
                ((Power)power).fromTag(powerNbt);
            }, () -> Apoli.LOGGER.warn("Received sync packet for entity without power holder."));
        });
    }
}

