/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin.integration.connector;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnBlockBreakPower;
import io.github.apace100.apoli.power.ActionOnBlockUsePower;
import io.github.apace100.apoli.power.PreventBlockUsePower;
import io.github.apace100.apoli.util.HarvestContext;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class ServerPlayerInteractionManagerMixin {
    @Shadow
    protected ServerLevel f_9244_;
    @Final
    @Shadow
    protected ServerPlayer f_9245_;

    @Inject(method={"tryBreakBlock"}, at={@At(value="HEAD")})
    private void cacheBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        HarvestContext.setBlockPosition(this.f_9244_, pos);
        HarvestContext.setCanHarvest(this.f_9245_.m_36298_(this.f_9244_.m_8055_(pos)));
    }

    @Inject(method={"tryBreakBlock"}, at={@At(value="RETURN")})
    private void origins$onBlockBreak(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        boolean harvested = HarvestContext.getCanHarvest();
        PowerHolderComponent.getPowers((Entity)this.f_9245_, ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply(HarvestContext.getBlockPosition())).forEach(p -> p.executeActions(harvested, pos, null));
        HarvestContext.clearCanHarvest();
        HarvestContext.clearBlockPosition();
    }

    @Inject(method={"interactBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;shouldCancelInteraction()Z")}, cancellable=true)
    private void preventBlockInteraction(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (PowerHolderComponent.getPowers((Entity)player, PreventBlockUsePower.class).stream().anyMatch(p -> p.doesPrevent((LevelReader)world, hitResult.m_82425_()))) {
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Inject(method={"interactBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;copy()Lnet/minecraft/item/ItemStack;")}, cancellable=true)
    private void executeBlockUseActions(ServerPlayer player, Level world, ItemStack stack, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        PowerHolderComponent.getPowers((Entity)player, ActionOnBlockUsePower.class).stream().filter(p -> p.shouldExecute(hitResult.m_82425_(), hitResult.m_82434_(), hand, stack)).forEach(p -> p.executeAction(hitResult.m_82425_(), hitResult.m_82434_(), hand));
    }
}

