/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import io.github.apace100.apoli.access.EndRespawningEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnItemUsePower;
import io.github.apace100.apoli.power.KeepInventoryPower;
import io.github.apace100.apoli.power.ModifyPlayerSpawnPower;
import io.github.apace100.apoli.power.PreventSleepPower;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.util.Tuple;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements ContainerListener,
EndRespawningEntity {
    @Shadow
    private ResourceKey<Level> f_8935_;
    @Shadow
    private BlockPos f_8936_;
    @Shadow
    @Final
    public MinecraftServer f_8924_;
    @Shadow
    public ServerGamePacketListenerImpl f_8906_;
    @Shadow
    public boolean f_8944_;
    @Shadow
    private boolean f_8937_;
    @Unique
    private ItemStack apoli$stackBeforeDrop;
    @Unique
    private boolean origins_isEndRespawning;

    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Shadow
    public abstract void m_5661_(Component var1, boolean var2);

    @Inject(method={"trySleep"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerEntity;setSpawnPoint(Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/util/math/BlockPos;FZZ)V")}, cancellable=true)
    public void preventAvianSleep(BlockPos pos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> info) {
        PowerHolderComponent.getPowers((Entity)this, PreventSleepPower.class).forEach(p -> {
            if (p.doesPrevent((LevelReader)this.m_9236_(), pos)) {
                if (p.doesAllowSpawnPoint()) {
                    ((ServerPlayer)this).m_9158_(this.m_9236_().m_46472_(), pos, this.m_146908_(), false, true);
                }
                info.setReturnValue((Object)Either.left(null));
                this.m_5661_((Component)Component.m_237115_((String)p.getMessage()), true);
            }
        });
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointDimension"}, cancellable=true)
    private void modifySpawnPointDimension(CallbackInfoReturnable<ResourceKey<Level>> info) {
        if (!this.origins_isEndRespawning && (this.f_8936_ == null || this.hasObstructedSpawn()) && PowerHolderComponent.getPowers((Entity)this, ModifyPlayerSpawnPower.class).size() > 0) {
            ModifyPlayerSpawnPower power = PowerHolderComponent.getPowers((Entity)this, ModifyPlayerSpawnPower.class).get(0);
            info.setReturnValue(power.dimension);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getSpawnPointPosition"}, cancellable=true)
    private void modifyPlayerSpawnPosition(CallbackInfoReturnable<BlockPos> info) {
        if (!this.origins_isEndRespawning && PowerHolderComponent.getPowers((Entity)this, ModifyPlayerSpawnPower.class).size() > 0) {
            if (this.f_8936_ == null) {
                info.setReturnValue((Object)this.findPlayerSpawn());
            } else if (this.hasObstructedSpawn()) {
                this.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132153_, 0.0f));
                info.setReturnValue((Object)this.findPlayerSpawn());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isSpawnForced"}, cancellable=true)
    private void modifySpawnPointSet(CallbackInfoReturnable<Boolean> info) {
        if (!this.origins_isEndRespawning && (this.f_8936_ == null || this.hasObstructedSpawn()) && PowerHolderComponent.hasPower((Entity)this, ModifyPlayerSpawnPower.class)) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="FIELD", opcode=180, target="Lnet/minecraft/server/network/ServerPlayerEntity;enchantmentTableSeed:I")})
    private void copyInventoryWhenKeeping(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((Entity)oldPlayer, KeepInventoryPower.class)) {
            this.m_150109_().m_36006_(oldPlayer.m_150109_());
        }
    }

    private boolean hasObstructedSpawn() {
        ServerLevel world = this.f_8924_.m_129880_(this.f_8935_);
        if (this.f_8936_ != null && world != null) {
            Optional optional = Player.m_36130_((ServerLevel)world, (BlockPos)this.f_8936_, (float)0.0f, (boolean)this.f_8937_, (boolean)true);
            return !optional.isPresent();
        }
        return false;
    }

    private BlockPos findPlayerSpawn() {
        ModifyPlayerSpawnPower power = PowerHolderComponent.getPowers((Entity)this, ModifyPlayerSpawnPower.class).get(0);
        Tuple<ServerLevel, BlockPos> spawn = power.getSpawn(true);
        if (spawn != null) {
            return (BlockPos)spawn.m_14419_();
        }
        return null;
    }

    @Inject(method={"dropSelectedItem"}, at={@At(value="HEAD")})
    private void cacheItemStackBeforeDropping(boolean entireStack, CallbackInfoReturnable<Boolean> cir) {
        this.apoli$stackBeforeDrop = this.m_150109_().m_36056_().m_41777_();
    }

    @Inject(method={"dropSelectedItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/screen/ScreenHandler;getSlotIndex(Lnet/minecraft/inventory/Inventory;I)Ljava/util/OptionalInt;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void checkItemUsageStopping(boolean entireStack, CallbackInfoReturnable<Boolean> cir, Inventory playerInventory, ItemStack itemStack) {
        if (this.m_6117_() && !ItemStack.m_41656_((ItemStack)this.apoli$stackBeforeDrop, (ItemStack)this.m_150109_().m_36056_())) {
            ActionOnItemUsePower.executeActions((Entity)this, itemStack, this.apoli$stackBeforeDrop, ActionOnItemUsePower.TriggerType.STOP, ActionOnItemUsePower.PriorityPhase.ALL);
        }
    }

    @Override
    public void setEndRespawning(boolean endSpawn) {
        this.origins_isEndRespawning = endSpawn;
    }

    @Override
    public boolean isEndRespawning() {
        return this.origins_isEndRespawning;
    }

    @Override
    public boolean hasRealRespawnPoint() {
        return this.f_8936_ != null && !this.hasObstructedSpawn();
    }
}

