/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.ActionOnBeingUsedPower;
import io.github.apace100.apoli.power.ActionOnEntityUsePower;
import io.github.apace100.apoli.power.ActionOnWakeUp;
import io.github.apace100.apoli.power.ActiveInteractionPower;
import io.github.apace100.apoli.power.DisableRegenPower;
import io.github.apace100.apoli.power.IgnoreWaterPower;
import io.github.apace100.apoli.power.InventoryPower;
import io.github.apace100.apoli.power.KeepInventoryPower;
import io.github.apace100.apoli.power.ModifyAirSpeedPower;
import io.github.apace100.apoli.power.ModifyDamageDealtPower;
import io.github.apace100.apoli.power.ModifyDamageTakenPower;
import io.github.apace100.apoli.power.ModifyExhaustionPower;
import io.github.apace100.apoli.power.ModifyFoodPower;
import io.github.apace100.apoli.power.ModifyProjectileDamagePower;
import io.github.apace100.apoli.power.PreventBeingUsedPower;
import io.github.apace100.apoli.power.PreventEntityUsePower;
import io.github.apace100.apoli.power.Prioritized;
import io.github.apace100.apoli.power.RestrictArmorPower;
import io.github.apace100.apoli.power.SwimmingPower;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.commands.CommandSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements Nameable,
CommandSource {
    @Shadow
    protected boolean f_36076_;
    @Shadow
    @Final
    public Inventory f_36093_;
    @Unique
    private InteractionResult apoli$CachedPriorityZeroResult;

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    @Shadow
    public abstract EntityDimensions m_6972_(Pose var1);

    @Shadow
    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Shadow
    public abstract ItemEntity m_36176_(ItemStack var1, boolean var2);

    @Shadow
    public abstract InteractionResult m_36157_(Entity var1, InteractionHand var2);

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"getOffGroundSpeed"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyFlySpeed(CallbackInfoReturnable<Float> cir) {
        cir.setReturnValue((Object)Float.valueOf(PowerHolderComponent.modify((Entity)this, ModifyAirSpeedPower.class, ((Float)cir.getReturnValue()).floatValue())));
    }

    @ModifyVariable(method={"eatFood"}, at=@At(value="HEAD"), argsOnly=true, ordinal=0)
    private ItemStack modifyEatenItemStack(ItemStack original) {
        List<ModifyFoodPower> mfps = PowerHolderComponent.getPowers((Entity)this, ModifyFoodPower.class);
        mfps = mfps.stream().filter(mfp -> mfp.doesApply(original)).collect(Collectors.toList());
        ItemStack newStack = original;
        for (ModifyFoodPower mfp2 : mfps) {
            newStack = mfp2.getConsumedItemStack(newStack);
        }
        ((ModifiableFoodEntity)((Object)this)).setCurrentModifyFoodPowers(mfps);
        ((ModifiableFoodEntity)((Object)this)).setOriginalFoodStack(original);
        return newStack;
    }

    @Inject(method={"interact"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventEntityInteraction(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        if (this.m_5833_()) {
            return;
        }
        ItemStack stack = this.m_21120_(hand);
        for (PreventEntityUsePower peup : PowerHolderComponent.getPowers((Entity)this, PreventEntityUsePower.class)) {
            if (!peup.doesApply(entity, hand, stack)) continue;
            cir.setReturnValue((Object)peup.executeAction(entity, hand));
            cir.cancel();
            return;
        }
        for (PreventBeingUsedPower pbup : PowerHolderComponent.getPowers(entity, PreventBeingUsedPower.class)) {
            if (!pbup.doesApply((Player)this, hand, stack)) continue;
            cir.setReturnValue((Object)pbup.executeAction((Player)this, hand));
            cir.cancel();
            return;
        }
        this.apoli$CachedPriorityZeroResult = InteractionResult.PASS;
        Prioritized.CallInstance callInstance = new Prioritized.CallInstance();
        callInstance.add((Entity)this, ActionOnEntityUsePower.class, p -> p.shouldExecute(entity, hand, stack) && p.getPriority() >= 0);
        callInstance.add(entity, ActionOnBeingUsedPower.class, p -> p.shouldExecute((Player)this, hand, stack) && p.getPriority() >= 0);
        for (int i = callInstance.getMaxPriority(); i >= 0; --i) {
            if (!callInstance.hasPowers(i)) continue;
            List powers = callInstance.getPowers(i);
            InteractionResult result = InteractionResult.PASS;
            for (ActiveInteractionPower ip : powers) {
                InteractionResult ar = InteractionResult.PASS;
                if (ip instanceof ActionOnEntityUsePower) {
                    ActionOnEntityUsePower aoeup = (ActionOnEntityUsePower)ip;
                    ar = aoeup.executeAction(entity, hand);
                } else if (ip instanceof ActionOnBeingUsedPower) {
                    ActionOnBeingUsedPower aobup = (ActionOnBeingUsedPower)ip;
                    ar = aobup.executeAction((Player)this, hand);
                }
                if (ar.m_19077_() && !result.m_19077_()) {
                    result = ar;
                    continue;
                }
                if (!ar.m_19080_() || result.m_19080_()) continue;
                result = ar;
            }
            if (i == 0) {
                this.apoli$CachedPriorityZeroResult = result;
                continue;
            }
            this.apoli$CachedPriorityZeroResult = InteractionResult.PASS;
            if (result == InteractionResult.PASS) continue;
            if (result.m_19080_()) {
                this.m_6674_(hand);
            }
            cir.setReturnValue((Object)result);
            break;
        }
    }

    @Inject(method={"damage"}, at={@At(value="RETURN", ordinal=3)}, cancellable=true)
    private void allowDamageIfModifyingPowersExist(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        boolean hasModifyingPower = false;
        if (source.m_7639_() != null) {
            hasModifyingPower = source.m_269533_(DamageTypeTags.f_268524_) ? PowerHolderComponent.hasPower(source.m_7639_(), ModifyProjectileDamagePower.class, mpdp -> mpdp.doesApply(source, amount, this)) : PowerHolderComponent.hasPower(source.m_7639_(), ModifyDamageDealtPower.class, mddp -> mddp.doesApply(source, amount, this));
        }
        if (hasModifyingPower |= PowerHolderComponent.hasPower((Entity)this, ModifyDamageTakenPower.class, mdtp -> mdtp.doesApply(source, amount))) {
            cir.setReturnValue((Object)super.m_6469_(source, amount));
        }
    }

    @Inject(method={"interact"}, at={@At(value="RETURN")}, cancellable=true)
    private void entityInteractionAfter(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult original = (InteractionResult)cir.getReturnValue();
        InteractionResult custom = InteractionResult.PASS;
        if (this.apoli$CachedPriorityZeroResult != InteractionResult.PASS) {
            custom = this.apoli$CachedPriorityZeroResult;
        } else if (cir.getReturnValue() == InteractionResult.PASS) {
            ItemStack stack = this.m_21120_(hand);
            Prioritized.CallInstance callInstance = new Prioritized.CallInstance();
            callInstance.add((Entity)this, ActionOnEntityUsePower.class, p -> p.shouldExecute(entity, hand, stack) && p.getPriority() < 0);
            callInstance.add(entity, ActionOnBeingUsedPower.class, p -> p.shouldExecute((Player)this, hand, stack) && p.getPriority() < 0);
            for (int i = -1; i >= callInstance.getMinPriority(); --i) {
                if (!callInstance.hasPowers(i)) continue;
                List powers = callInstance.getPowers(i);
                InteractionResult result = InteractionResult.PASS;
                for (ActiveInteractionPower ip : powers) {
                    InteractionResult ar = InteractionResult.PASS;
                    if (ip instanceof ActionOnEntityUsePower) {
                        ActionOnEntityUsePower aoeup = (ActionOnEntityUsePower)ip;
                        ar = aoeup.executeAction(entity, hand);
                    } else if (ip instanceof ActionOnBeingUsedPower) {
                        ActionOnBeingUsedPower aobup = (ActionOnBeingUsedPower)ip;
                        ar = aobup.executeAction((Player)this, hand);
                    }
                    if (ar.m_19077_() && !result.m_19077_()) {
                        result = ar;
                        continue;
                    }
                    if (!ar.m_19080_() || result.m_19080_()) continue;
                    result = ar;
                }
                if (result == InteractionResult.PASS) continue;
                custom = result;
                break;
            }
        }
        if (custom.m_19080_()) {
            this.m_6674_(hand);
        }
        if (!(original.m_19077_() && !custom.m_19077_() || original.m_19080_() && !custom.m_19080_())) {
            cir.setReturnValue((Object)custom);
        }
    }

    @Inject(method={"dismountVehicle"}, at={@At(value="HEAD")})
    private void sendPlayerDismountPacket(CallbackInfo ci) {
        if (!this.m_9236_().f_46443_ && this.m_20202_() instanceof Player) {
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            buf.writeInt(this.m_19879_());
            ServerPlayNetworking.send((ServerPlayer)((ServerPlayer)this.m_20202_()), (ResourceLocation)ModPackets.PLAYER_DISMOUNT, (FriendlyByteBuf)buf);
        }
    }

    @Inject(method={"updateSwimming"}, at={@At(value="TAIL")})
    private void updateSwimmingPower(CallbackInfo ci) {
        if (PowerHolderComponent.hasPower((Entity)this, SwimmingPower.class)) {
            this.m_20282_(this.m_20142_() && !this.m_20159_());
            this.f_19798_ = this.m_6069_();
            if (this.m_6069_()) {
                this.f_19789_ = 0.0f;
                Vec3 look = this.m_20154_();
                this.m_6478_(MoverType.SELF, new Vec3(look.f_82479_ / 4.0, look.f_82480_ / 4.0, look.f_82481_ / 4.0));
            }
        } else if (PowerHolderComponent.hasPower((Entity)this, IgnoreWaterPower.class)) {
            this.m_20282_(false);
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="HEAD")})
    private void invokeWakeUpAction(boolean bl, boolean updateSleepingPlayers, CallbackInfo ci) {
        if (!bl && !updateSleepingPlayers && this.m_21257_().isPresent()) {
            BlockPos sleepingPos = (BlockPos)this.m_21257_().get();
            PowerHolderComponent.getPowers((Entity)this, ActionOnWakeUp.class).stream().filter(p -> p.doesApply(sleepingPos)).forEach(p -> p.executeActions(sleepingPos, Direction.DOWN));
        }
    }

    @Inject(method={"canFoodHeal"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableHeal(CallbackInfoReturnable<Boolean> info) {
        if (PowerHolderComponent.hasPower((Entity)this, DisableRegenPower.class)) {
            info.setReturnValue((Object)false);
        }
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"addExhaustion"}, ordinal=0, name={"exhaustion"})
    private float modifyExhaustion(float exhaustionIn) {
        return PowerHolderComponent.modify((Entity)this, ModifyExhaustionPower.class, exhaustionIn);
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V")})
    private void dropAdditionalInventory(CallbackInfo ci) {
        PowerHolderComponent.getPowers((Entity)this, InventoryPower.class).forEach(inventoryPower -> {
            if (inventoryPower.shouldDropOnDeath()) {
                inventoryPower.dropItemsOnDeath();
            }
        });
        PowerHolderComponent.getPowers((Entity)this, KeepInventoryPower.class).forEach(keepInventoryPower -> keepInventoryPower.preventItemsFromDropping((Container)this.f_36093_));
    }

    @Inject(method={"dropInventory"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerInventory;dropAll()V", shift=At.Shift.AFTER)})
    private void restoreKeptInventory(CallbackInfo ci) {
        PowerHolderComponent.getPowers((Entity)this, KeepInventoryPower.class).forEach(keepInventoryPower -> keepInventoryPower.restoreSavedItems((Container)this.f_36093_));
    }

    @Inject(method={"canEquip"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventArmorDispensing(ItemStack stack, CallbackInfoReturnable<Boolean> info) {
        EquipmentSlot slot = Mob.m_147233_((ItemStack)stack);
        PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)this);
        if (component.getPowers(RestrictArmorPower.class).stream().anyMatch(rap -> !rap.canEquip(stack, slot))) {
            info.setReturnValue((Object)false);
        }
    }
}

