/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.InvisibilityPower;
import io.github.apace100.apoli.power.ModelColorPower;
import io.github.apace100.apoli.power.PreventFeatureRenderPower;
import io.github.apace100.apoli.power.ShakingPower;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin
extends EntityRenderer<LivingEntity> {
    protected LivingEntityRendererMixin(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    @Inject(method={"isShaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void letPlayersShakeTheirBodies(LivingEntity entity, CallbackInfoReturnable<Boolean> cir) {
        if (PowerHolderComponent.hasPower((Entity)entity, ShakingPower.class)) {
            cir.setReturnValue((Object)true);
        }
    }

    @ModifyVariable(method={"render"}, at=@At(value="STORE"), ordinal=2)
    private boolean preventOutlineRendering(boolean original, LivingEntity livingEntity) {
        List<InvisibilityPower> invisibilityPowers = PowerHolderComponent.getPowers((Entity)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderOutline)) {
            return false;
        }
        return original;
    }

    @ModifyVariable(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/VertexConsumerProvider;getBuffer(Lnet/minecraft/client/render/RenderLayer;)Lnet/minecraft/client/render/VertexConsumer;", shift=At.Shift.BEFORE), ordinal=0)
    private RenderType changeRenderLayerWhenTranslucent(RenderType original, LivingEntity entity) {
        if (entity != null && PowerHolderComponent.getPowers((Entity)entity, ModelColorPower.class).stream().anyMatch(ModelColorPower::isTranslucent)) {
            return RenderType.m_110467_((ResourceLocation)this.m_5478_((Entity)entity));
        }
        return original;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/feature/FeatureRenderer;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;ILnet/minecraft/entity/Entity;FFFFFF)V"))
    private void preventFeatureRendering(RenderLayer featureRenderer, PoseStack matrices, MultiBufferSource vertexConsumers, int light, Entity entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch, LivingEntity livingEntity) {
        List<InvisibilityPower> invisibilityPowers = PowerHolderComponent.getPowers((Entity)livingEntity, InvisibilityPower.class);
        if (invisibilityPowers.size() > 0 && invisibilityPowers.stream().noneMatch(InvisibilityPower::shouldRenderArmor)) {
            return;
        }
        Class<?> cls = featureRenderer.getClass();
        if (!PowerHolderComponent.getPowers(entity, PreventFeatureRenderPower.class).stream().anyMatch(p -> p.doesApply(cls))) {
            featureRenderer.m_6494_(matrices, vertexConsumers, light, entity, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
        }
    }

    @ModifyArgs(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/entity/model/EntityModel;render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;IIFFFF)V"))
    @Environment(value=EnvType.CLIENT)
    private void renderColorChangedModel(Args args, LivingEntity livingEntity, float f, float tickDelta, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        List<ModelColorPower> modelColorPowers = PowerHolderComponent.getPowers((Entity)livingEntity, ModelColorPower.class);
        if (modelColorPowers.size() > 0) {
            float r = modelColorPowers.stream().map(ModelColorPower::getRed).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float g = modelColorPowers.stream().map(ModelColorPower::getGreen).reduce((a, b) -> Float.valueOf(a.floatValue() * b.floatValue())).get().floatValue();
            float b2 = modelColorPowers.stream().map(ModelColorPower::getBlue).reduce((a, c) -> Float.valueOf(a.floatValue() * c.floatValue())).get().floatValue();
            float a2 = modelColorPowers.stream().map(ModelColorPower::getAlpha).min(Float::compare).get().floatValue();
            args.set(4, (Object)Float.valueOf(((Float)args.get(4)).floatValue() * r));
            args.set(5, (Object)Float.valueOf(((Float)args.get(5)).floatValue() * g));
            args.set(6, (Object)Float.valueOf(((Float)args.get(6)).floatValue() * b2));
            args.set(7, (Object)Float.valueOf(((Float)args.get(7)).floatValue() * a2));
        }
    }
}

