/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeRegistry;
import io.github.apace100.apoli.power.PreventItemUsePower;
import io.github.apace100.apoli.power.TooltipPower;
import io.github.apace100.apoli.util.ApoliConfigClient;
import io.github.apace100.apoli.util.StackPowerUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Environment(value=EnvType.CLIENT)
@Mixin(value={ItemStack.class})
public abstract class ItemStackMixinClient {
    @Shadow
    public abstract UseAnim m_41780_();

    @Shadow
    protected abstract int m_41618_();

    @Shadow
    private static boolean m_41626_(int flags, ItemStack.TooltipPart tooltipSection) {
        return (flags & tooltipSection.m_41809_()) == 0;
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addUnusableTooltip(@Nullable Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        if (player != null) {
            ApoliConfigClient.Tooltips config = ((ApoliConfigClient)Apoli.config).tooltips;
            if (!config.showUsabilityHints || !ItemStackMixinClient.m_41626_(this.m_41618_(), ItemStack.TooltipPart.ADDITIONAL)) {
                return;
            }
            List<PreventItemUsePower> powers = PowerHolderComponent.getPowers((Entity)player, PreventItemUsePower.class).stream().filter(p -> p.doesPrevent((ItemStack)this)).toList();
            int powerCountWithHidden = powers.size();
            powers = powers.stream().filter(p -> !p.getType().isHidden()).toList();
            if (powerCountWithHidden == 0) {
                return;
            }
            String translationKeyBase = "tooltip.apoli.unusable." + this.m_41780_().name().toLowerCase(Locale.ROOT);
            ChatFormatting textColor = ChatFormatting.GRAY;
            ChatFormatting powerColor = ChatFormatting.RED;
            if (config.compactUsabilityHints || powers.size() == 0) {
                if (powers.size() == 1) {
                    PreventItemUsePower power = powers.get(0);
                    MutableComponent preventText = Component.m_237110_((String)(translationKeyBase + ".single"), (Object[])new Object[]{power.getType().getName().m_130940_(powerColor)}).m_130940_(textColor);
                    list.add((Component)preventText);
                } else {
                    list.add((Component)Component.m_237110_((String)(translationKeyBase + ".multiple"), (Object[])new Object[]{Component.m_237113_((String)("" + (powers.size() == 0 ? powerCountWithHidden : powers.size()))).m_130940_(powerColor)}).m_130940_(textColor));
                }
            } else {
                MutableComponent powerNameList = powers.get(0).getType().getName().m_130940_(powerColor);
                for (int i = 1; i < powers.size(); ++i) {
                    powerNameList = powerNameList.m_7220_((Component)Component.m_237113_((String)", ").m_130940_(textColor));
                    powerNameList = powerNameList.m_7220_((Component)powers.get(i).getType().getName().m_130940_(powerColor));
                }
                MutableComponent preventText = Component.m_237110_((String)(translationKeyBase + ".single"), (Object[])new Object[]{powerNameList}).m_130940_(textColor);
                list.add((Component)preventText);
            }
        }
    }

    @Inject(method={"getTooltip"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;hasNbt()Z", ordinal=1)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void addEquipmentPowerTooltips(Player player, TooltipFlag context, CallbackInfoReturnable<List<Component>> cir, List<Component> list) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            List<StackPowerUtil.StackPower> powers = StackPowerUtil.getPowers((ItemStack)this, slot).stream().filter(sp -> !sp.isHidden).toList();
            if (powers.size() <= 0) continue;
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)("item.modifiers." + slot.m_20751_())).m_130940_(ChatFormatting.GRAY));
            powers.forEach(sp -> {
                if (PowerTypeRegistry.contains(sp.powerId)) {
                    PowerType powerType = PowerTypeRegistry.get(sp.powerId);
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)powerType.getName()).m_130940_(sp.isNegative ? ChatFormatting.RED : ChatFormatting.BLUE));
                    if (context.m_7050_()) {
                        list.add((Component)Component.m_237113_((String)"  ").m_7220_((Component)powerType.getDescription()).m_130940_(ChatFormatting.GRAY));
                    }
                }
            });
        }
        PowerHolderComponent.getPowers((Entity)player, TooltipPower.class).stream().filter(t -> t.doesApply((ItemStack)this)).sorted(Comparator.comparing(TooltipPower::getOrder)).forEachOrdered(t -> t.addToTooltip(list));
    }
}

