/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.EntityLinkedItemStack;
import io.github.apace100.apoli.access.MutableItemStack;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnItemUsePower;
import io.github.apace100.apoli.power.PreventItemUsePower;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ItemStack.class})
public abstract class ItemStackMixin
implements MutableItemStack,
EntityLinkedItemStack {
    @Shadow
    @Deprecated
    private Item f_41589_;
    @Shadow
    private CompoundTag f_41590_;
    @Shadow
    private int f_41587_;
    @Unique
    private ItemStack apoli$usedItemStack;
    @Unique
    private Entity apoli$holdingEntity;

    @Shadow
    public abstract int m_41779_();

    @Shadow
    @Nullable
    public abstract Entity m_41609_();

    @Override
    public Entity getEntity() {
        Entity vanillaHolder = this.m_41609_();
        if (vanillaHolder == null) {
            return this.apoli$holdingEntity;
        }
        return vanillaHolder;
    }

    @Override
    public void setEntity(Entity entity) {
        this.apoli$holdingEntity = entity;
    }

    @Inject(method={"copy"}, at={@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;setBobbingAnimationTime(I)V", shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void copyNewParams(CallbackInfoReturnable<ItemStack> cir, ItemStack itemStack) {
        if (this.apoli$holdingEntity != null) {
            ((EntityLinkedItemStack)itemStack).setEntity(this.apoli$holdingEntity);
        }
    }

    @Inject(method={"finishUsing"}, at={@At(value="HEAD")})
    public void callActionOnUseFinishBefore(Level world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        this.apoli$usedItemStack = ((ItemStack)this).m_41777_();
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, this.apoli$usedItemStack, ActionOnItemUsePower.TriggerType.FINISH, ActionOnItemUsePower.PriorityPhase.BEFORE);
        }
    }

    @Inject(method={"finishUsing"}, at={@At(value="RETURN")})
    public void callActionOnUseFinishAfter(Level world, LivingEntity user, CallbackInfoReturnable<ItemStack> cir) {
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)cir.getReturnValue(), this.apoli$usedItemStack, ActionOnItemUsePower.TriggerType.FINISH, ActionOnItemUsePower.PriorityPhase.AFTER);
        }
    }

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void callActionOnUseInstantBefore(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (user != null) {
            PowerHolderComponent component = (PowerHolderComponent)PowerHolderComponent.KEY.get((Object)user);
            ItemStack stackInHand = user.m_21120_(hand);
            for (PreventItemUsePower piup : component.getPowers(PreventItemUsePower.class)) {
                if (!piup.doesPrevent(stackInHand)) continue;
                cir.setReturnValue((Object)InteractionResultHolder.m_19100_((Object)stackInHand));
                return;
            }
            if (this.m_41779_() == 0) {
                ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.INSTANT, ActionOnItemUsePower.PriorityPhase.BEFORE);
            } else {
                ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.START, ActionOnItemUsePower.PriorityPhase.BEFORE);
            }
        }
    }

    @Inject(method={"use"}, at={@At(value="RETURN")})
    private void callActionOnUseInstantAfter(Level world, Player user, InteractionHand hand, CallbackInfoReturnable<InteractionResultHolder<ItemStack>> cir) {
        if (user != null) {
            InteractionResult ar = ((InteractionResultHolder)cir.getReturnValue()).m_19089_();
            if (!ar.m_19077_()) {
                return;
            }
            if (this.m_41779_() == 0) {
                ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)((InteractionResultHolder)cir.getReturnValue()).m_19095_(), (ItemStack)((InteractionResultHolder)cir.getReturnValue()).m_19095_(), ActionOnItemUsePower.TriggerType.INSTANT, ActionOnItemUsePower.PriorityPhase.AFTER);
            } else {
                ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)((InteractionResultHolder)cir.getReturnValue()).m_19095_(), (ItemStack)((InteractionResultHolder)cir.getReturnValue()).m_19095_(), ActionOnItemUsePower.TriggerType.START, ActionOnItemUsePower.PriorityPhase.AFTER);
            }
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="HEAD")})
    private void callActionOnUseStopBefore(Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.STOP, ActionOnItemUsePower.PriorityPhase.BEFORE);
        }
    }

    @Inject(method={"onStoppedUsing"}, at={@At(value="RETURN")})
    private void callActionOnUseStopAfter(Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.STOP, ActionOnItemUsePower.PriorityPhase.AFTER);
        }
    }

    @Inject(method={"usageTick"}, at={@At(value="HEAD")})
    private void callActionOnUseDuringBefore(Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.DURING, ActionOnItemUsePower.PriorityPhase.BEFORE);
        }
    }

    @Inject(method={"usageTick"}, at={@At(value="RETURN")})
    private void callActionOnUseDuringAfter(Level world, LivingEntity user, int remainingUseTicks, CallbackInfo ci) {
        if (user != null) {
            ActionOnItemUsePower.executeActions((Entity)user, (ItemStack)this, (ItemStack)this, ActionOnItemUsePower.TriggerType.DURING, ActionOnItemUsePower.PriorityPhase.AFTER);
        }
    }

    @Override
    public void setItem(Item item) {
        this.f_41589_ = item;
    }

    @Override
    public void setFrom(ItemStack stack) {
        this.setItem(stack.m_41720_());
        this.f_41590_ = stack.m_41783_();
        this.f_41587_ = stack.m_41613_();
    }
}

