/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.OverlayPower;
import io.github.apace100.apoli.power.OverrideHudTexturePower;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
@Environment(value=EnvType.CLIENT)
public class InGameHudMixin {
    @Shadow
    @Final
    private Minecraft f_92986_;

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerInteractionManager;getCurrentGameMode()Lnet/minecraft/world/GameMode;", ordinal=0)})
    private void renderOnHud(GuiGraphics context, float tickDelta, CallbackInfo ci) {
        boolean hudHidden = this.f_92986_.f_91066_.f_92062_;
        boolean thirdPerson = !this.f_92986_.f_91066_.m_92176_().m_90612_();
        PowerHolderComponent.withPower(this.f_92986_.m_91288_(), OverlayPower.class, p -> {
            if (p.getDrawPhase() != OverlayPower.DrawPhase.BELOW_HUD) {
                return false;
            }
            if (hudHidden && p.doesHideWithHud()) {
                return false;
            }
            return !thirdPerson || p.shouldBeVisibleInThirdPerson();
        }, OverlayPower::render);
    }

    @ModifyArg(method={"drawHeart"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"), index=0)
    public ResourceLocation changeHearts(ResourceLocation original) {
        Optional power = PowerHolderComponent.getPowers((Entity)this.f_92986_.f_91074_, OverrideHudTexturePower.class).stream().findFirst();
        if (power.isPresent()) {
            return ((OverrideHudTexturePower)power.get()).getStatusBarTexture();
        }
        return original;
    }

    @ModifyArg(method={"renderExperienceBar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"), index=0)
    public ResourceLocation changeXpBarTextures(ResourceLocation original) {
        Optional power = PowerHolderComponent.getPowers((Entity)this.f_92986_.f_91074_, OverrideHudTexturePower.class).stream().findFirst();
        if (power.isPresent()) {
            return ((OverrideHudTexturePower)power.get()).getStatusBarTexture();
        }
        return original;
    }

    @ModifyArg(method={"renderCrosshair"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"), index=0)
    public ResourceLocation changeCrosshair(ResourceLocation original) {
        Optional power = PowerHolderComponent.getPowers((Entity)this.f_92986_.f_91074_, OverrideHudTexturePower.class).stream().findFirst();
        if (power.isPresent()) {
            return ((OverrideHudTexturePower)power.get()).getStatusBarTexture();
        }
        return original;
    }

    @ModifyArg(method={"renderMountJumpBar"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"), index=0)
    public ResourceLocation changeMountJumpBar(ResourceLocation original) {
        Optional power = PowerHolderComponent.getPowers((Entity)this.f_92986_.f_91074_, OverrideHudTexturePower.class).stream().findFirst();
        if (power.isPresent()) {
            return ((OverrideHudTexturePower)power.get()).getStatusBarTexture();
        }
        return original;
    }

    @ModifyArg(method={"renderMountHealth"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lnet/minecraft/util/Identifier;IIIIII)V"), index=0)
    public ResourceLocation changeMountHealth(ResourceLocation original) {
        Optional power = PowerHolderComponent.getPowers((Entity)this.f_92986_.f_91074_, OverrideHudTexturePower.class).stream().findFirst();
        if (power.isPresent()) {
            return ((OverrideHudTexturePower)power.get()).getStatusBarTexture();
        }
        return original;
    }
}

