/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.access.ModifiableFoodEntity;
import io.github.apace100.apoli.power.ModifyFoodPower;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetHealthPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class HungerManagerMixin {
    @Shadow
    private int f_38696_;
    @Shadow
    private float f_38697_;
    @Unique
    private Player player;
    @Unique
    private boolean apoli$ShouldUpdateManually = false;

    @Redirect(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getHunger()I"))
    private int modifyHunger(FoodProperties foodComponent, Item item, ItemStack stack) {
        this.apoli$ShouldUpdateManually = false;
        int baseValue = foodComponent.m_38744_();
        if (this.player == null) {
            return baseValue;
        }
        List<Modifier> modifiers = ((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers().stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getFoodModifiers().stream()).toList();
        int newFood = (int)ModifierUtil.applyModifiers((Entity)this.player, modifiers, (double)baseValue);
        if (newFood != baseValue && newFood == 0) {
            this.apoli$ShouldUpdateManually = true;
        }
        return newFood;
    }

    @Redirect(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/FoodComponent;getSaturationModifier()F"))
    private float modifySaturation(FoodProperties foodComponent, Item item, ItemStack stack) {
        float baseValue = foodComponent.m_38745_();
        if (this.player == null) {
            return baseValue;
        }
        List<Modifier> modifiers = ((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers().stream().filter(p -> p.doesApply(stack)).flatMap(p -> p.getSaturationModifiers().stream()).toList();
        float newSaturation = (float)ModifierUtil.applyModifiers((Entity)this.player, modifiers, (double)baseValue);
        if (newSaturation != baseValue && newSaturation == 0.0f) {
            this.apoli$ShouldUpdateManually = true;
        }
        return newSaturation;
    }

    @Inject(method={"eat(Lnet/minecraft/world/item/Item;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;add(IF)V", shift=At.Shift.AFTER)})
    private void executeAdditionalEatAction(Item item, ItemStack stack, LivingEntity adapter_injected_2, CallbackInfo ci) {
        if (this.player == null || this.player.m_9236_().f_46443_) {
            return;
        }
        ((ModifiableFoodEntity)this.player).getCurrentModifyFoodPowers().stream().filter(p -> p.doesApply(stack)).forEach(ModifyFoodPower::eat);
        if (this.apoli$ShouldUpdateManually) {
            ((ServerPlayer)this.player).f_8906_.m_9829_((Packet)new ClientboundSetHealthPacket(this.player.m_21223_(), this.f_38696_, this.f_38697_));
        }
    }

    @Inject(method={"update"}, at={@At(value="HEAD")})
    private void cachePlayer(Player player, CallbackInfo ci) {
        this.player = player;
    }
}

