/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.mixin;

import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.ActionOnBlockUsePower;
import io.github.apace100.apoli.power.PreventBlockUsePower;
import java.util.stream.Collectors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.multiplayer.prediction.PredictiveAction;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public abstract class ClientPlayerInteractionManagerMixin {
    @Shadow
    @Final
    private ClientPacketListener f_105190_;

    @Shadow
    protected abstract void m_233729_(ClientLevel var1, PredictiveAction var2);

    @Inject(method={"interactBlockInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;shouldCancelInteraction()Z")}, cancellable=true)
    private void preventBlockInteraction(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        if (PowerHolderComponent.getPowers((Entity)player, PreventBlockUsePower.class).stream().anyMatch(p -> p.doesPrevent((LevelReader)player.m_9236_(), hitResult.m_82425_()))) {
            cir.setReturnValue((Object)InteractionResult.PASS);
        }
    }

    @Inject(method={"interactBlockInternal"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/network/ClientPlayerEntity;shouldCancelInteraction()Z", shift=At.Shift.AFTER)}, cancellable=true)
    private void executeBlockUseActions(LocalPlayer player, InteractionHand hand, BlockHitResult hitResult, CallbackInfoReturnable<InteractionResult> cir) {
        InteractionResult result = InteractionResult.PASS;
        for (ActionOnBlockUsePower p2 : PowerHolderComponent.getPowers((Entity)player, ActionOnBlockUsePower.class).stream().filter(p -> p.shouldExecute(hitResult.m_82425_(), hitResult.m_82434_(), hand, player.m_21120_(hand))).collect(Collectors.toList())) {
            InteractionResult ar = p2.executeAction(hitResult.m_82425_(), hitResult.m_82434_(), hand);
            if (ar.m_19077_() && !result.m_19077_()) {
                result = ar;
                continue;
            }
            if (!ar.m_19080_() || result.m_19080_()) continue;
            result = ar;
        }
        if (result.m_19077_()) {
            this.m_233729_(player.f_108545_, id -> new ServerboundUseItemOnPacket(hand, hitResult, id));
            cir.setReturnValue((Object)result);
        }
    }
}

