/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.data;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.access.NameMutableDamageSource;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;

public class DamageSourceDescription {
    public static final SerializableData DATA = new SerializableData().add("name", SerializableDataTypes.STRING);
    private static final Multimap<String, TagKey<DamageType>> STRING_TO_TAGS = Multimaps.newSetMultimap(new HashMap(), HashSet::new);
    private static final Map<TagKey<DamageType>, String> TAG_TO_STRING = new HashMap<TagKey<DamageType>, String>();
    private static final int TAG_COUNT;
    private final String name;
    private final Set<TagKey<DamageType>> desiredDamageTypeTags = new HashSet<TagKey<DamageType>>();
    private ResourceKey<DamageType> damageType;

    private static void registerDamageTypeTagMapping(String jsonKey, TagKey<DamageType> tag) {
        STRING_TO_TAGS.put((Object)jsonKey, tag);
        TAG_TO_STRING.put(tag, jsonKey);
    }

    public DamageSourceDescription(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Set<TagKey<DamageType>> getDamageTypeTags() {
        return Set.copyOf(this.desiredDamageTypeTags);
    }

    public void addDamageTypeTag(TagKey<DamageType> damageTypeTag) {
        this.desiredDamageTypeTags.add(damageTypeTag);
    }

    public ResourceKey<DamageType> getDamageType(DamageSources damageSources) {
        if (this.damageType == null) {
            this.findBestMatchingDamageType(damageSources);
        }
        return this.damageType;
    }

    public DamageSource create(DamageSources damageSources) {
        DamageSource damageSource = damageSources.m_269079_(this.getDamageType(damageSources));
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public DamageSource create(DamageSources damageSources, Entity attacker) {
        DamageSource damageSource = damageSources.m_269298_(this.getDamageType(damageSources), attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    public DamageSource create(DamageSources damageSources, Entity source, Entity attacker) {
        DamageSource damageSource = damageSources.m_268998_(this.getDamageType(damageSources), source, attacker);
        this.overwriteDamageSourceMessageKey(damageSource);
        return damageSource;
    }

    private void overwriteDamageSourceMessageKey(DamageSource source) {
        ((NameMutableDamageSource)source).setName(this.name);
    }

    private void findBestMatchingDamageType(DamageSources damageSources) {
        Holder bestMatch;
        Optional<Holder.Reference> bestMatchingDamageType = damageSources.f_268645_.m_203611_().max(Comparator.comparingInt(this::getTagMatches));
        if (bestMatchingDamageType.isPresent()) {
            bestMatch = (Holder)bestMatchingDamageType.get();
            int bestMatchTagCount = this.getTagMatches((Holder<DamageType>)bestMatch);
            if (bestMatchTagCount < TAG_COUNT) {
                Apoli.LOGGER.warn("Could not find a perfect damage type for legacy damage source field, best match: {} out of {} tags with damage type \"{}\". Consider creating your own custom damage type.", (Object)bestMatchTagCount, (Object)TAG_COUNT, (Object)bestMatch.m_203543_().map(ResourceKey::m_135782_).map(ResourceLocation::toString).orElse("<unknown>"));
            }
        } else {
            throw new NoSuchElementException("Damage type registry was empty or not loaded yet");
        }
        this.damageType = (ResourceKey)bestMatch.m_203543_().orElseThrow();
    }

    private int getTagMatches(Holder<DamageType> damageType) {
        int count = 0;
        for (TagKey tag : STRING_TO_TAGS.values()) {
            if (damageType.m_203656_(tag) != this.desiredDamageTypeTags.contains(tag)) continue;
            ++count;
        }
        return count;
    }

    public static DamageSourceDescription fromData(SerializableData.Instance dataInstance) {
        DamageSourceDescription damageSourceDescription = new DamageSourceDescription(dataInstance.getString("name"));
        for (String jsonKey : STRING_TO_TAGS.keySet()) {
            if (!dataInstance.getBoolean(jsonKey)) continue;
            STRING_TO_TAGS.get((Object)jsonKey).forEach(damageSourceDescription::addDamageTypeTag);
        }
        return damageSourceDescription;
    }

    public static SerializableData.Instance toData(SerializableData data, DamageSourceDescription damageSourceDescription) {
        SerializableData.Instance instance = new SerializableData.Instance(data);
        instance.set("name", (Object)damageSourceDescription.getName());
        Set<TagKey<DamageType>> tags = damageSourceDescription.getDamageTypeTags();
        for (Map.Entry<TagKey<DamageType>, String> damageTagPair : TAG_TO_STRING.entrySet()) {
            TagKey<DamageType> tag = damageTagPair.getKey();
            String jsonKey = damageTagPair.getValue();
            boolean isTrueAlready = instance.isPresent(jsonKey) && instance.getBoolean(jsonKey);
            instance.set(jsonKey, (Object)(isTrueAlready || tags.contains(tag) ? 1 : 0));
        }
        return instance;
    }

    static {
        DamageSourceDescription.registerDamageTypeTagMapping("bypasses_armor", (TagKey<DamageType>)DamageTypeTags.f_268490_);
        DamageSourceDescription.registerDamageTypeTagMapping("fire", (TagKey<DamageType>)DamageTypeTags.f_268745_);
        DamageSourceDescription.registerDamageTypeTagMapping("unblockable", (TagKey<DamageType>)DamageTypeTags.f_276146_);
        DamageSourceDescription.registerDamageTypeTagMapping("magic", (TagKey<DamageType>)DamageTypeTags.f_268731_);
        DamageSourceDescription.registerDamageTypeTagMapping("magic", (TagKey<DamageType>)DamageTypeTags.f_268640_);
        DamageSourceDescription.registerDamageTypeTagMapping("out_of_world", (TagKey<DamageType>)DamageTypeTags.f_268738_);
        DamageSourceDescription.registerDamageTypeTagMapping("projectile", (TagKey<DamageType>)DamageTypeTags.f_268524_);
        DamageSourceDescription.registerDamageTypeTagMapping("explosive", (TagKey<DamageType>)DamageTypeTags.f_268415_);
        for (String jsonKey : STRING_TO_TAGS.keySet()) {
            DATA.add(jsonKey, SerializableDataTypes.BOOLEAN, (Object)false);
        }
        TAG_COUNT = STRING_TO_TAGS.values().size();
    }
}

