/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.component;

import com.google.common.collect.Lists;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.ServerTickingComponent;
import io.github.apace100.apoli.Apoli;
import io.github.apace100.apoli.integration.ModifyValueCallback;
import io.github.apace100.apoli.networking.ModPackets;
import io.github.apace100.apoli.power.AttributeModifyTransferPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.PowerTypeReference;
import io.github.apace100.apoli.power.ValueModifyingPower;
import io.github.apace100.apoli.util.modifier.Modifier;
import io.github.apace100.apoli.util.modifier.ModifierUtil;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public interface PowerHolderComponent
extends AutoSyncedComponent,
ServerTickingComponent {
    public static final ComponentKey<PowerHolderComponent> KEY = ComponentRegistry.getOrCreate((ResourceLocation)Apoli.identifier("powers"), PowerHolderComponent.class);

    public void removePower(PowerType<?> var1, ResourceLocation var2);

    public int removeAllPowersFromSource(ResourceLocation var1);

    public List<PowerType<?>> getPowersFromSource(ResourceLocation var1);

    public boolean addPower(PowerType<?> var1, ResourceLocation var2);

    public boolean hasPower(PowerType<?> var1);

    public boolean hasPower(PowerType<?> var1, ResourceLocation var2);

    public <T extends Power> T getPower(PowerType<T> var1);

    public List<Power> getPowers();

    public Set<PowerType<?>> getPowerTypes(boolean var1);

    public <T extends Power> List<T> getPowers(Class<T> var1);

    public <T extends Power> List<T> getPowers(Class<T> var1, boolean var2);

    public List<ResourceLocation> getSources(PowerType<?> var1);

    public void sync();

    public static void sync(Entity entity) {
        KEY.sync((Object)entity);
    }

    public static void syncPower(Entity entity, PowerType<?> powerType) {
        if (entity == null || entity.m_9236_().f_46443_) {
            return;
        }
        if (powerType instanceof PowerTypeReference) {
            powerType = ((PowerTypeReference)powerType).getReferencedPowerType();
        }
        if (powerType == null) {
            return;
        }
        PowerType<?> finalPowerType = powerType;
        KEY.maybeGet((Object)entity).ifPresent(phc -> {
            if (phc.hasPower(finalPowerType)) {
                Object power = phc.getPower(finalPowerType);
                Tag elem = ((Power)power).toTag();
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.writeInt(entity.m_19879_());
                buf.m_130085_(finalPowerType.getIdentifier());
                CompoundTag compound = new CompoundTag();
                compound.m_128365_("Data", elem);
                buf.m_130079_(compound);
                for (ServerPlayer player : PlayerLookup.tracking((Entity)entity)) {
                    ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)ModPackets.SYNC_POWER, (FriendlyByteBuf)buf);
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer self = (ServerPlayer)entity;
                    ServerPlayNetworking.send((ServerPlayer)self, (ResourceLocation)ModPackets.SYNC_POWER, (FriendlyByteBuf)buf);
                }
            }
        });
    }

    public static <T extends Power> void withPower(Entity entity, Class<T> powerClass, Predicate<T> power, Consumer<T> with) {
        if (entity instanceof LivingEntity) {
            Optional<Power> optional = ((PowerHolderComponent)KEY.get((Object)entity)).getPowers(powerClass).stream().filter(p -> power == null || power.test(p)).findAny();
            optional.ifPresent(with);
        }
    }

    public static <T extends Power> void withPowers(Entity entity, Class<T> powerClass, Predicate<T> filter, Consumer<T> with) {
        if (entity instanceof LivingEntity) {
            ((PowerHolderComponent)KEY.get((Object)entity)).getPowers(powerClass).stream().filter(p -> filter == null || filter.test(p)).forEach(with);
        }
    }

    public static <T extends Power> List<T> getPowers(Entity entity, Class<T> powerClass) {
        if (entity instanceof LivingEntity) {
            return ((PowerHolderComponent)KEY.get((Object)entity)).getPowers(powerClass);
        }
        return Lists.newArrayList();
    }

    public static <T extends Power> boolean hasPower(Entity entity, Class<T> powerClass) {
        return PowerHolderComponent.hasPower(entity, powerClass, null);
    }

    public static <T extends Power> boolean hasPower(Entity entity, Class<T> powerClass, Predicate<T> powerFilter) {
        if (entity instanceof LivingEntity) {
            return ((PowerHolderComponent)KEY.get((Object)entity)).getPowers().stream().anyMatch(p -> powerClass.isAssignableFrom(p.getClass()) && p.isActive() && (powerFilter == null || powerFilter.test(p)));
        }
        return false;
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue) {
        return (float)PowerHolderComponent.modify(entity, powerClass, (double)baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter) {
        return (float)PowerHolderComponent.modify(entity, powerClass, (double)baseValue, powerFilter, null);
    }

    public static <T extends ValueModifyingPower> float modify(Entity entity, Class<T> powerClass, float baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        return (float)PowerHolderComponent.modify(entity, powerClass, (double)baseValue, powerFilter, powerAction);
    }

    public static <T extends ValueModifyingPower> double modify(Entity entity, Class<T> powerClass, double baseValue) {
        return PowerHolderComponent.modify(entity, powerClass, baseValue, null, null);
    }

    public static <T extends ValueModifyingPower> double modify(Entity entity, Class<T> powerClass, double baseValue, Predicate<T> powerFilter, Consumer<T> powerAction) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PowerHolderComponent powerHolder = (PowerHolderComponent)KEY.get((Object)entity);
            List<T> powers = powerHolder.getPowers(powerClass);
            List<Modifier> mps = powers.stream().filter(p -> powerFilter == null || powerFilter.test(p)).flatMap(p -> p.getModifiers().stream()).collect(Collectors.toList());
            if (powerAction != null) {
                powers.stream().filter(p -> powerFilter == null || powerFilter.test(p)).forEach(powerAction);
            }
            powerHolder.getPowers(AttributeModifyTransferPower.class).stream().filter(p -> p.doesApply(powerClass)).forEach(p -> p.addModifiers(mps));
            ((ModifyValueCallback)ModifyValueCallback.EVENT.invoker()).collectModifiers(living, powerClass, baseValue, mps);
            return ModifierUtil.applyModifiers(entity, mps, baseValue);
        }
        return baseValue;
    }
}

