/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.apoli.command.PowerOperation;
import io.github.apace100.apoli.command.PowerTypeArgumentType;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.PowerType;
import io.github.apace100.apoli.power.VariableIntPower;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ObjectiveArgument;
import net.minecraft.commands.arguments.ScoreHolderArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.scores.Score;

public class ResourceCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"resource").requires(cs -> cs.m_6761_(2))).then(Commands.m_82127_((String)"has").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.HAS)))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.GET)))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.SET))))))).then(Commands.m_82127_((String)"change").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.CHANGE))))))).then(Commands.m_82127_((String)"operation").then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).then(Commands.m_82129_((String)"power", (ArgumentType)PowerTypeArgumentType.power()).then(Commands.m_82129_((String)"operation", (ArgumentType)PowerOperation.operation()).then(Commands.m_82129_((String)"entity", (ArgumentType)ScoreHolderArgument.m_108217_()).then(Commands.m_82129_((String)"objective", (ArgumentType)ObjectiveArgument.m_101957_()).executes(command -> ResourceCommand.resource((CommandContext<CommandSourceStack>)command, SubCommand.OPERATION)))))))));
    }

    private static int resource(CommandContext<CommandSourceStack> command, SubCommand sub) throws CommandSyntaxException {
        Entity player = EntityArgument.m_91452_(command, (String)"target");
        if (!(player instanceof LivingEntity)) {
            // empty if block
        }
        PowerType<?> powerType = PowerTypeArgumentType.getPower(command, "power");
        Optional phc = PowerHolderComponent.KEY.maybeGet((Object)player);
        if (phc.isEmpty()) {
            ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.apoli.resource.invalid_entity"));
            return 0;
        }
        Object power = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player)).getPower(powerType);
        if (power instanceof VariableIntPower) {
            VariableIntPower vIntPower = (VariableIntPower)power;
            switch (sub.ordinal()) {
                case 0: {
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
                    return 1;
                }
                case 1: {
                    int i = vIntPower.getValue();
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.m_6302_(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case 2: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    vIntPower.setValue(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.set.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.m_6302_(), i}), true);
                    return 1;
                }
                case 3: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    int total = vIntPower.getValue() + i;
                    vIntPower.setValue(total);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.add.success.single", (Object[])new Object[]{i, powerType.getIdentifier(), player.m_6302_(), total}), true);
                    return 1;
                }
                case 4: {
                    Score score = ((CommandSourceStack)command.getSource()).m_81377_().m_129896_().m_83471_(ScoreHolderArgument.m_108223_(command, (String)"entity"), ObjectiveArgument.m_101960_(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(vIntPower, score);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.operation.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.m_6302_(), vIntPower.getValue()}), true);
                    return 1;
                }
            }
        } else if (power instanceof CooldownPower) {
            CooldownPower cooldownPower = (CooldownPower)power;
            switch (sub.ordinal()) {
                case 0: {
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237115_((String)"commands.execute.conditional.pass"), true);
                    return 1;
                }
                case 1: {
                    int i = cooldownPower.getRemainingTicks();
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.get.success", (Object[])new Object[]{player.m_6302_(), i, powerType.getIdentifier()}), true);
                    return i;
                }
                case 2: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.setCooldown(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.set.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.m_6302_(), i}), true);
                    return 1;
                }
                case 3: {
                    int i = IntegerArgumentType.getInteger(command, (String)"value");
                    cooldownPower.modify(i);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.add.success.single", (Object[])new Object[]{i, powerType.getIdentifier(), player.m_6302_(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
                case 4: {
                    Score score = ((CommandSourceStack)command.getSource()).m_81377_().m_129896_().m_83471_(ScoreHolderArgument.m_108223_(command, (String)"entity"), ObjectiveArgument.m_101960_(command, (String)"objective"));
                    ((PowerOperation.Operation)command.getArgument("operation", PowerOperation.Operation.class)).apply(cooldownPower, score);
                    PowerHolderComponent.syncPower(player, powerType);
                    ((CommandSourceStack)command.getSource()).m_288197_(() -> Component.m_237110_((String)"commands.scoreboard.players.operation.success.single", (Object[])new Object[]{powerType.getIdentifier(), player.m_6302_(), cooldownPower.getRemainingTicks()}), true);
                    return 1;
                }
            }
        } else {
            switch (sub.ordinal()) {
                case 0: {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237115_((String)"commands.execute.conditional.fail"));
                    return 0;
                }
                case 1: {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237110_((String)"commands.scoreboard.players.get.null", (Object[])new Object[]{powerType.getIdentifier(), player.m_6302_()}));
                    return 0;
                }
                case 2: 
                case 3: 
                case 4: {
                    ((CommandSourceStack)command.getSource()).m_81352_((Component)Component.m_237115_((String)"argument.scoreHolder.empty"));
                    return 0;
                }
            }
        }
        return 0;
    }

    public static enum SubCommand {
        HAS,
        GET,
        SET,
        CHANGE,
        OPERATION;

    }
}

