/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.apace100.apoli.power.CooldownPower;
import io.github.apace100.apoli.power.Power;
import io.github.apace100.apoli.power.VariableIntPower;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.world.scores.Score;

public class PowerOperation
implements ArgumentType<Operation> {
    public static final SimpleCommandExceptionType INVALID_OPERATION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"arguments.operation.invalid"));
    public static final SimpleCommandExceptionType DIVISION_ZERO_EXCEPTION = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"arguments.operation.div0"));

    public static PowerOperation operation() {
        return new PowerOperation();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82967_((String[])new String[]{"=", "+=", "-=", "*=", "/=", "%=", "<", ">", "><"}, (SuggestionsBuilder)builder);
    }

    public Operation parse(StringReader stringReader) throws CommandSyntaxException {
        String stringOperator;
        if (!stringReader.canRead()) {
            throw INVALID_OPERATION.create();
        }
        int i = stringReader.getCursor();
        while (stringReader.canRead() && stringReader.peek() != ' ') {
            stringReader.skip();
        }
        switch (stringOperator = stringReader.getString().substring(i, stringReader.getCursor())) {
            case "=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(score.m_83400_());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).setCooldown(score.m_83400_());
                    }
                };
            }
            case "+=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() + score.m_83400_());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).modify(score.m_83400_());
                    }
                };
            }
            case "-=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() - score.m_83400_());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).modify(-score.m_83400_());
                    }
                };
            }
            case "*=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        ((VariableIntPower)power).setValue(((VariableIntPower)power).getValue() * score.m_83400_());
                    } else if (power instanceof CooldownPower) {
                        ((CooldownPower)power).setCooldown(((CooldownPower)power).getRemainingTicks() * score.m_83400_());
                    }
                };
            }
            case "/=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int r = resource.getValue();
                        int s = score.m_83400_();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        resource.setValue(Math.floorDiv(r, s));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int c = cooldownPower.getRemainingTicks();
                        int s = score.m_83400_();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        cooldownPower.setCooldown(Math.floorDiv(c, s));
                    }
                };
            }
            case "%=": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int r = resource.getValue();
                        int s = score.m_83400_();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        resource.setValue(Math.floorMod(r, s));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int c = cooldownPower.getRemainingTicks();
                        int s = score.m_83400_();
                        if (s == 0) {
                            throw DIVISION_ZERO_EXCEPTION.create();
                        }
                        cooldownPower.setCooldown(Math.floorMod(c, s));
                    }
                };
            }
            case "<": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        resource.setValue(Math.min(resource.getValue(), score.m_83400_()));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        cooldownPower.setCooldown(Math.min(cooldownPower.getRemainingTicks(), score.m_83400_()));
                    }
                };
            }
            case ">": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        resource.setValue(Math.max(resource.getValue(), score.m_83400_()));
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        cooldownPower.setCooldown(Math.max(cooldownPower.getRemainingTicks(), score.m_83400_()));
                    }
                };
            }
            case "><": {
                return (power, score) -> {
                    if (power instanceof VariableIntPower) {
                        VariableIntPower resource = (VariableIntPower)power;
                        int v = score.m_83400_();
                        score.m_83402_(resource.getValue());
                        resource.setValue(v);
                    } else if (power instanceof CooldownPower) {
                        CooldownPower cooldownPower = (CooldownPower)power;
                        int v = score.m_83400_();
                        score.m_83402_(cooldownPower.getRemainingTicks());
                        cooldownPower.setCooldown(v);
                    }
                };
            }
        }
        throw INVALID_OPERATION.create();
    }

    public static interface Operation {
        public void apply(Power var1, Score var2) throws CommandSyntaxException;
    }
}

