/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.apoli;

import com.mojang.brigadier.CommandDispatcher;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import io.github.apace100.apoli.command.PowerCommand;
import io.github.apace100.apoli.command.ResourceCommand;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.component.PowerHolderComponentImpl;
import io.github.apace100.apoli.global.GlobalPowerSetLoader;
import io.github.apace100.apoli.networking.ModPacketsC2S;
import io.github.apace100.apoli.power.ActionOnBlockBreakPower;
import io.github.apace100.apoli.power.PowerTypes;
import io.github.apace100.apoli.power.factory.PowerFactories;
import io.github.apace100.apoli.power.factory.action.BiEntityActions;
import io.github.apace100.apoli.power.factory.action.BlockActions;
import io.github.apace100.apoli.power.factory.action.EntityActions;
import io.github.apace100.apoli.power.factory.action.ItemActions;
import io.github.apace100.apoli.power.factory.condition.BiEntityConditions;
import io.github.apace100.apoli.power.factory.condition.BiomeConditions;
import io.github.apace100.apoli.power.factory.condition.BlockConditions;
import io.github.apace100.apoli.power.factory.condition.DamageConditions;
import io.github.apace100.apoli.power.factory.condition.EntityConditions;
import io.github.apace100.apoli.power.factory.condition.FluidConditions;
import io.github.apace100.apoli.power.factory.condition.ItemConditions;
import io.github.apace100.apoli.registry.ApoliClassData;
import io.github.apace100.apoli.util.AddPowerLootFunction;
import io.github.apace100.apoli.util.ApoliConfig;
import io.github.apace100.apoli.util.ApoliResourceConditions;
import io.github.apace100.apoli.util.GainedPowerCriterion;
import io.github.apace100.apoli.util.ModifiedCraftingRecipe;
import io.github.apace100.apoli.util.PowerLootCondition;
import io.github.apace100.apoli.util.PowerRestrictedCraftingRecipe;
import io.github.apace100.apoli.util.RemovePowerLootFunction;
import io.github.apace100.apoli.util.SavedBlockPosition;
import io.github.apace100.apoli.util.Scheduler;
import io.github.apace100.apoli.util.modifier.ModifierOperations;
import io.github.apace100.calio.mixin.CriteriaRegistryInvoker;
import io.github.apace100.calio.resource.OrderedResourceListenerInitializer;
import io.github.apace100.calio.resource.OrderedResourceListenerManager;
import io.github.ladysnake.pal.AbilitySource;
import io.github.ladysnake.pal.Pal;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceConditions;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LevelReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Apoli
implements ModInitializer,
EntityComponentInitializer,
OrderedResourceListenerInitializer {
    public static ApoliConfig config;
    public static MinecraftServer server;
    public static final Scheduler SCHEDULER;
    public static final String MODID = "apoli";
    public static final Logger LOGGER;
    public static String VERSION;
    public static int[] SEMVER;
    public static final AbilitySource LEGACY_POWER_SOURCE;
    public static final boolean PERFORM_VERSION_CHECK = false;

    public void onInitialize() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            SavedBlockPosition saved = new SavedBlockPosition((LevelReader)world, pos);
            PowerHolderComponent.getPowers((Entity)player, ActionOnBlockBreakPower.class).stream().filter(p -> p.doesApply(saved)).forEach(power -> power.executeActions(true, pos, null));
        });
        ServerLifecycleEvents.SERVER_STARTED.register(s -> {
            server = s;
        });
        FabricLoader.getInstance().getModContainer(MODID).ifPresent(modContainer -> {
            VERSION = modContainer.getMetadata().getVersion().getFriendlyString();
            if (VERSION.contains("+")) {
                VERSION = VERSION.split("\\+")[0];
            }
            if (VERSION.contains("-")) {
                VERSION = VERSION.split("-")[0];
            }
            String[] splitVersion = VERSION.split("\\.");
            SEMVER = new int[splitVersion.length];
            for (int i = 0; i < SEMVER.length; ++i) {
                Apoli.SEMVER[i] = Integer.parseInt(splitVersion[i]);
            }
        });
        ModPacketsC2S.register();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            PowerCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
            ResourceCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        });
        Registry.m_122965_((Registry)BuiltInRegistries.f_256769_, (ResourceLocation)Apoli.identifier("power_restricted"), PowerRestrictedCraftingRecipe.SERIALIZER);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256769_, (ResourceLocation)Apoli.identifier("modified"), ModifiedCraftingRecipe.SERIALIZER);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)Apoli.identifier("add_power"), (Object)AddPowerLootFunction.TYPE);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256753_, (ResourceLocation)Apoli.identifier("remove_power"), (Object)RemovePowerLootFunction.TYPE);
        Registry.m_122965_((Registry)BuiltInRegistries.f_256991_, (ResourceLocation)Apoli.identifier("power"), (Object)PowerLootCondition.TYPE);
        ApoliClassData.registerAll();
        ModifierOperations.registerAll();
        PowerFactories.register();
        EntityConditions.register();
        BiEntityConditions.register();
        ItemConditions.register();
        BlockConditions.register();
        DamageConditions.register();
        FluidConditions.register();
        BiomeConditions.register();
        EntityActions.register();
        ItemActions.register();
        BlockActions.register();
        BiEntityActions.register();
        ResourceManagerHelper.get((PackType)PackType.SERVER_DATA).registerReloadListener((IdentifiableResourceReloadListener)new GlobalPowerSetLoader());
        ResourceConditions.register((ResourceLocation)ApoliResourceConditions.ANY_NAMESPACE_LOADED, jsonObject -> ApoliResourceConditions.namespacesLoaded(jsonObject, PowerTypes.LOADED_NAMESPACES, false));
        ResourceConditions.register((ResourceLocation)ApoliResourceConditions.ALL_NAMESPACES_LOADED, jsonObject -> ApoliResourceConditions.namespacesLoaded(jsonObject, PowerTypes.LOADED_NAMESPACES, true));
        CriteriaRegistryInvoker.callRegister((CriterionTrigger)GainedPowerCriterion.INSTANCE);
        LOGGER.info("Apoli " + VERSION + " has initialized. Ready to power up your game!");
    }

    public static ResourceLocation identifier(String path) {
        return new ResourceLocation(MODID, path);
    }

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.beginRegistration(LivingEntity.class, PowerHolderComponent.KEY).impl(PowerHolderComponentImpl.class).respawnStrategy(RespawnCopyStrategy.ALWAYS_COPY).end(PowerHolderComponentImpl::new);
    }

    public void registerResourceListeners(OrderedResourceListenerManager manager) {
        manager.register(PackType.SERVER_DATA, (IdentifiableResourceReloadListener)new PowerTypes()).complete();
    }

    static {
        SCHEDULER = new Scheduler();
        LOGGER = LogManager.getLogger(Apoli.class);
        VERSION = "";
        LEGACY_POWER_SOURCE = Pal.getAbilitySource((ResourceLocation)Apoli.identifier("power_source"));
    }
}

