/*
 * Decompiled with CFR 0.152.
 */
package elocindev.item_obliterator.forge.utils;

import elocindev.item_obliterator.forge.ItemObliterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class Utils {
    public static String getItemId(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).toString();
    }

    public static boolean shouldRecipeBeDisabled(Item item) {
        return Utils.shouldRecipeBeDisabled(Utils.getItemId(item));
    }

    public static boolean shouldRecipeBeDisabled(String itemid) {
        if (Utils.isDisabled(itemid)) {
            return true;
        }
        if (!ItemObliterator.Config.use_hashmap_optimizations) {
            for (String blacklisted_id : ItemObliterator.Config.only_disable_recipes) {
                if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
                if (blacklisted_id.equals(itemid)) {
                    return true;
                }
                if (!blacklisted_id.startsWith("!") || !itemid.matches(blacklisted_id = blacklisted_id.substring(1))) continue;
                return true;
            }
        } else if (ItemObliterator.only_disable_recipes.contains(itemid)) {
            return true;
        }
        return false;
    }

    public static boolean isDisabled(String itemid) {
        if (itemid.equals("minecraft:air")) {
            return false;
        }
        if (!ItemObliterator.Config.use_hashmap_optimizations) {
            for (String blacklisted_id : ItemObliterator.Config.blacklisted_items) {
                if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
                if (blacklisted_id.equals(itemid)) {
                    return true;
                }
                if (!blacklisted_id.startsWith("!") || !itemid.matches(blacklisted_id = blacklisted_id.substring(1))) continue;
                return true;
            }
        } else if (ItemObliterator.blacklisted_items.contains(itemid)) {
            return true;
        }
        return false;
    }

    public static boolean isDisabled(ItemStack stack) {
        if (stack == null || stack.m_150930_(Items.f_41852_)) {
            return false;
        }
        CompoundTag nbt = stack.m_41783_();
        if (nbt != null) {
            for (String blacklisted_nbt : ItemObliterator.Config.blacklisted_nbt) {
                if (blacklisted_nbt == null || blacklisted_nbt.startsWith("//")) continue;
                String nbtString = nbt.toString();
                if (nbtString.contains(blacklisted_nbt)) {
                    return true;
                }
                if (!blacklisted_nbt.startsWith("!") || !nbtString.matches(blacklisted_nbt = blacklisted_nbt.substring(1))) continue;
                return true;
            }
        }
        return Utils.isDisabled(Utils.getItemId(stack.m_41720_()));
    }

    public static boolean isDisabledInteract(String itemid) {
        for (String blacklisted_id : ItemObliterator.Config.only_disable_interactions) {
            if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
            if (blacklisted_id.equals(itemid)) {
                return true;
            }
            if (!blacklisted_id.startsWith("!") || !itemid.matches(blacklisted_id = blacklisted_id.substring(1))) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisabledInteract(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return Utils.isDisabledInteract(Utils.getItemId(stack.m_41720_()));
    }

    public static boolean isDisabledAttack(String itemid) {
        for (String blacklisted_id : ItemObliterator.Config.only_disable_attacks) {
            if (blacklisted_id == null || blacklisted_id.startsWith("//")) continue;
            if (blacklisted_id.equals(itemid)) {
                return true;
            }
            if (!blacklisted_id.startsWith("!") || !itemid.matches(blacklisted_id = blacklisted_id.substring(1))) continue;
            return true;
        }
        return false;
    }
}

