/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import com.github.L_Ender.cataclysm.init.ModParticle;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Custom_Poof_Particle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private float initialR;
    private float initialG;
    private float initialB;

    protected Custom_Poof_Particle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, float r, float g, float b, float gravity) {
        super(level, x, y, z);
        this.f_107226_ = gravity;
        this.f_172258_ = 0.9f;
        this.sprites = sprites;
        this.f_107215_ = xSpeed;
        this.f_107216_ = ySpeed;
        this.f_107217_ = zSpeed;
        this.f_107227_ = r / 255.0f;
        this.f_107228_ = g / 255.0f;
        this.f_107229_ = b / 255.0f;
        this.initialR = r / 255.0f;
        this.initialG = g / 255.0f;
        this.initialB = b / 255.0f;
        this.f_107663_ = 0.25f + level.f_46441_.m_188501_() * 0.1f;
        this.f_107225_ = (int)(24.0 / ((double)this.f_107223_.m_188501_() * 0.8 + 0.2)) + 2;
        this.m_108339_(sprites);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    public int m_6355_(float p_106821_) {
        return 240;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_172259_ && this.f_107213_ == this.f_107210_) {
                this.f_107215_ *= 1.1;
                this.f_107217_ *= 1.1;
            }
            this.f_107215_ *= (double)this.f_172258_;
            this.f_107216_ *= (double)this.f_172258_;
            this.f_107217_ *= (double)this.f_172258_;
            if (this.f_107218_) {
                this.f_107215_ *= (double)0.7f;
                this.f_107217_ *= (double)0.7f;
            }
            float progress = (float)this.f_107224_ / (float)this.f_107225_;
            this.f_107227_ = Mth.m_14179_((float)progress, (float)this.initialR, (float)1.0f);
            this.f_107228_ = Mth.m_14179_((float)progress, (float)this.initialG, (float)1.0f);
            this.f_107229_ = Mth.m_14179_((float)progress, (float)this.initialB, (float)1.0f);
            this.f_107230_ = Mth.m_14179_((float)progress, (float)1.0f, (float)0.5f);
        }
        this.m_108339_(this.sprites);
    }

    public static class PoofData
    implements ParticleOptions {
        public static final ParticleOptions.Deserializer<PoofData> DESERIALIZER = new ParticleOptions.Deserializer<PoofData>(){

            public PoofData fromCommand(ParticleType<PoofData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                float gravity = reader.readFloat();
                return new PoofData(r, g, b, gravity);
            }

            public PoofData fromNetwork(ParticleType<PoofData> particleTypeIn, FriendlyByteBuf buffer) {
                return new PoofData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readFloat());
            }
        };
        private final int r;
        private final int g;
        private final int b;
        private final float gravity;

        public PoofData(int r, int g, int b, float gravity) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.gravity = gravity;
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeFloat(this.gravity);
        }

        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, Float.valueOf(this.gravity));
        }

        public ParticleType<PoofData> m_6012_() {
            return (ParticleType)ModParticle.CUSTOM_POOF.get();
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getR() {
            return this.r;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getG() {
            return this.g;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getB() {
            return this.b;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float getGravity() {
            return this.gravity;
        }

        public static Codec<PoofData> CODEC(ParticleType<PoofData> particleType) {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(PoofData::getR), (App)Codec.INT.fieldOf("g").forGetter(PoofData::getG), (App)Codec.INT.fieldOf("b").forGetter(PoofData::getB), (App)Codec.FLOAT.fieldOf("gravity").forGetter(PoofData::getGravity)).apply((Applicative)codecBuilder, PoofData::new));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<PoofData> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(PoofData type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Custom_Poof_Particle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprites, type.getR(), type.getG(), type.getB(), type.getGravity());
        }
    }
}

