/*
 * Decompiled with CFR 0.152.
 */
package io.github.ladysnake.pal.impl.mixin;

import com.mojang.authlib.GameProfile;
import io.github.ladysnake.pal.AbilityTracker;
import io.github.ladysnake.pal.PlayerAbility;
import io.github.ladysnake.pal.VanillaAbilities;
import io.github.ladysnake.pal.impl.PalInternals;
import io.github.ladysnake.pal.impl.PlayerAbilityView;
import io.github.ladysnake.pal.impl.VanillaAbilityTracker;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerEntityMixin
extends Player
implements PlayerAbilityView {
    @Unique
    private final Map<PlayerAbility, AbilityTracker> palAbilities = new LinkedHashMap<PlayerAbility, AbilityTracker>();

    public ServerPlayerEntityMixin(Level world, BlockPos pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(MinecraftServer server, ServerLevel world, GameProfile profile, CallbackInfo ci) {
        PalInternals.populate(this, this.palAbilities);
    }

    @Override
    public Iterable<PlayerAbility> listPalAbilities() {
        return this.palAbilities.keySet();
    }

    @Override
    public AbilityTracker get(PlayerAbility abilityId) {
        return this.palAbilities.get(abilityId);
    }

    @Override
    public void refreshAllPalAbilities(boolean syncVanilla) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            if (ability == VanillaAbilities.FLYING) continue;
            this.get(ability).refresh(false);
        }
        if (syncVanilla) {
            this.m_6885_();
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerPlayerInteractionManager;setGameMode(Lnet/minecraft/world/GameMode;Lnet/minecraft/world/GameMode;)V", shift=At.Shift.AFTER)})
    private void copyAbilitiesAfterRespawn(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        if (alive) {
            CompoundTag nbt = new CompoundTag();
            ((ServerPlayerEntityMixin)oldPlayer).writeAbilitiesToTag(nbt, null);
            this.readAbilitiesFromTag(nbt, null);
        }
    }

    @Inject(method={"sendAbilitiesUpdate"}, at={@At(value="NEW", target="net/minecraft/network/packet/s2c/play/PlayerAbilitiesS2CPacket")})
    private void checkAbilityConsistency(CallbackInfo ci) {
        for (PlayerAbility ability : this.listPalAbilities()) {
            AbilityTracker tracker = this.get(ability);
            if (!(tracker instanceof VanillaAbilityTracker) || ability == VanillaAbilities.FLYING) continue;
            ((VanillaAbilityTracker)tracker).checkConflict();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="RETURN")})
    private void writeAbilitiesToTag(CompoundTag tag, CallbackInfo ci) {
        ListTag list = new ListTag();
        for (Map.Entry<PlayerAbility, AbilityTracker> entry : this.palAbilities.entrySet()) {
            CompoundTag abilityTag = new CompoundTag();
            abilityTag.m_128359_("ability_id", entry.getKey().getId().toString());
            entry.getValue().save(abilityTag);
            list.add((Object)abilityTag);
        }
        tag.m_128365_("playerabilitylib:abilities", (Tag)list);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;readCustomDataFromNbt(Lnet/minecraft/nbt/NbtCompound;)V", shift=At.Shift.AFTER)})
    private void readAbilitiesFromTag(CompoundTag tag, CallbackInfo ci) {
        for (Tag t : tag.m_128437_("playerabilitylib:abilities", 10)) {
            CompoundTag abilityTag = (CompoundTag)t;
            if (!abilityTag.m_128425_("ability_id", 8)) continue;
            String abilityId = abilityTag.m_128461_("ability_id");
            AbilityTracker tracker = this.palAbilities.get(PalInternals.getAbility(ResourceLocation.m_135820_((String)abilityId)));
            if (tracker != null) {
                tracker.load(abilityTag);
                continue;
            }
            PalInternals.LOGGER.warn("Encountered unknown ability {} while deserializing data for {}", (Object)abilityId, (Object)this);
        }
    }
}

